package com.sfa.operation.domain.risk.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 风控门店任务表
 *
 * @TableName risk_store_task
 */
@Accessors(chain = true)
@TableName(value = "risk_store_task")
@Data
public class RiskStoreTask implements Serializable {
    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long rstId;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 门店类型
     */
    private String storeType;

    /**
     * 门头照图片
     */
    private String storePicture;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 经销商编码
     */
    private String dealerCode;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 坐标
     */
    private String coordinates;

    /**
     * 礼盒/礼袋是否在售(逗号分隔)
     */
    private String lhlds;

    /**
     * SKU数量
     */
    private Integer skuNum;

    /**
     * 大日期图片(逗号分隔)
     */
    private String longTimePictures;

    /**
     * 备注
     */
    private String remark;

    /**
     * 常规陈列判定结果
     */
    private String cgclRiskR;

    /**
     * 档期陈列判定结果
     */
    private String dqclRiskR;

    /**
     * 常规陈列-1-形式
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String dModal1;

    /**
     * 常规陈列-1-陈列费用
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private BigDecimal dCost1;

    /**
     * 常规陈列-1-照片
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String dPhotos1;

    /**
     * 常规陈列-1-检核结果
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String dRiskR1;

    /**
     * 常规陈列-2-形式
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String dModal2;

    /**
     * 常规陈列-2-陈列费用
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private BigDecimal dCost2;

    /**
     * 常规陈列-2-照片
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String dPhotos2;

    /**
     * 常规陈列-2-检核结果
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String dRiskR2;

    /**
     * 常规陈列-3-形式
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String dModal3;

    /**
     * 常规陈列-3-陈列费用
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private BigDecimal dCost3;

    /**
     * 常规陈列-3-照片
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String dPhotos3;

    /**
     * 常规陈列-3-检核结果
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String dRiskR3;

    /**
     * 档期陈列-1-形式
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String pModal1;

    /**
     * 档期陈列-1-陈列费用
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private BigDecimal pCost1;

    /**
     * 档期陈列-1-照片
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String pPhotos1;

    /**
     * 档期陈列-1-检核结果
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String pRiskR1;

    /**
     * 档期陈列-2-形式
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String pModal2;

    /**
     * 档期陈列-2-陈列费用
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private BigDecimal pCost2;

    /**
     * 档期陈列-2-照片
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String pPhotos2;

    /**
     * 档期陈列-2-检核结果
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String pRiskR2;

    /**
     * 档期陈列-3-形式
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String pModal3;

    /**
     * 档期陈列-3-陈列费用
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private BigDecimal pCost3;

    /**
     * 档期陈列-3-照片
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String pPhotos3;

    /**
     * 档期陈列-3-检核结果
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String pRiskR3;

    /**
     * 档期补差1-内容
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String bcNr1;

    /**
     * 档期补差1-情况
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String bcQk1;

    /**
     * 档期补差1-照片
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String bcPhotos1;

    /**
     * 档期补差1-检核结果
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String bcRiskR1;

    /**
     * 档期补差2-内容
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String bcNr2;

    /**
     * 档期补差2-情况
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String bcQk2;

    /**
     * 档期补差2-照片
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String bcPhotos2;

    /**
     * 档期补差2-检核结果
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String bcRiskR2;

    /**
     * 档期补差3-内容
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String bcNr3;

    /**
     * 档期补差3-情况
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String bcQk3;

    /**
     * 档期补差3-照片
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String bcPhotos3;

    /**
     * 档期补差3-检核结果
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String bcRiskR3;

    /**
     * 虎皮210g价格
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String priceHp210;

    /**
     * 虎皮210g口味铺市月份
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String kwYmHp210;

    /**
     * 虎皮105g价格
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String priceHp105;

    /**
     * 虎皮105g口味铺市月份
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String kwYmHp105;

    /**
     * 虎皮68g价格
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String priceHp68;

    /**
     * 虎皮68g口味铺市月份
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String kwYmHp68;

    /**
     * 鸡肉豆堡120g价格
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String priceJrdb120;

    /**
     * 鸡肉豆堡120g口味铺市月份
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String kwYmJrdb120;

    /**
     * 牛肉豆堡120g价格
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String priceNrdb120;

    /**
     * 牛肉豆堡120g口味铺市月份
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String kwYmNrdb120;

    /**
     * 去骨凤爪72g价格
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String priceQg72;

    /**
     * 去骨凤爪72g口味铺市月份
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String kwYmQg72;

    /**
     * 去骨凤爪138g价格
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String priceQg138;

    /**
     * 去骨凤爪138g口味铺市月份
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String kwYmQg138;

    /**
     * 虎皮小鸡腿80g价格
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String priceHpjt80;

    /**
     * 虎皮小鸡腿80g口味铺市月份
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String kwYmHpjt80;

    /**
     * 老卤价格
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String priceLl;

    /**
     * 老卤口味铺市月份
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String kwYmLl;

    /**
     * 虎皮单支价格
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String priceHpDz;

    /**
     * 虎皮单支口味铺市月份
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String kwYmHpDz;

    /**
     * 虎皮散称价格
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String priceHpSc;

    /**
     * 虎皮散称口味铺市月份
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String kwYmHpSc;

    /**
     * 创建人
     */
    private String createBy;

    /**
     * 创建人工号
     */
    private String createEmpNo;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新者
     */
    private String updateBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    public void detailInit() {
        /**
         * 常规陈列-1-形式
         */
        this.dModal1 = null;

        /**
         * 常规陈列-1-陈列费用
         */
        this.dCost1 = null;

        /**
         * 常规陈列-1-照片
         */
        this.dPhotos1 = null;

        /**
         * 常规陈列-1-检核结果
         */
        this.dRiskR1 = null;

        /**
         * 常规陈列-2-形式
         */
        this.dModal2 = null;

        /**
         * 常规陈列-2-陈列费用
         */
        this.dCost2 = null;

        /**
         * 常规陈列-2-照片
         */
        this.dPhotos2 = null;

        /**
         * 常规陈列-2-检核结果
         */
        this.dRiskR2 = null;

        /**
         * 常规陈列-3-形式
         */
        this.dModal3 = null;

        /**
         * 常规陈列-3-陈列费用
         */
        this.dCost3 = null;

        /**
         * 常规陈列-3-照片
         */
        this.dPhotos3 = null;

        /**
         * 常规陈列-3-检核结果
         */
        this.dRiskR3 = null;

        /**
         * 档期陈列-1-形式
         */
        this.pModal1 = null;

        /**
         * 档期陈列-1-陈列费用
         */
        this.pCost1 = null;

        /**
         * 档期陈列-1-照片
         */
        this.pPhotos1 = null;

        /**
         * 档期陈列-1-检核结果
         */
        this.pRiskR1 = null;

        /**
         * 档期陈列-2-形式
         */
        this.pModal2 = null;

        /**
         * 档期陈列-2-陈列费用
         */
        this.pCost2 = null;

        /**
         * 档期陈列-2-照片
         */
        this.pPhotos2 = null;

        /**
         * 档期陈列-2-检核结果
         */
        this.pRiskR2 = null;

        /**
         * 档期陈列-3-形式
         */
        this.pModal3 = null;

        /**
         * 档期陈列-3-陈列费用
         */
        this.pCost3 = null;

        /**
         * 档期陈列-3-照片
         */
        this.pPhotos3 = null;

        /**
         * 档期陈列-3-检核结果
         */
        this.pRiskR3 = null;

        /**
         * 档期补差1-内容
         */
        this.bcNr1 = null;

        /**
         * 档期补差1-情况
         */
        this.bcQk1 = null;

        /**
         * 档期补差1-照片
         */
        this.bcPhotos1 = null;

        /**
         * 档期补差1-检核结果
         */
        this.bcRiskR1 = null;

        /**
         * 档期补差2-内容
         */
        this.bcNr2 = null;

        /**
         * 档期补差2-情况
         */
        this.bcQk2 = null;

        /**
         * 档期补差2-照片
         */
        this.bcPhotos2 = null;

        /**
         * 档期补差2-检核结果
         */
        this.bcRiskR2 = null;

        /**
         * 档期补差3-内容
         */
        this.bcNr3 = null;

        /**
         * 档期补差3-情况
         */
        this.bcQk3 = null;

        /**
         * 档期补差3-照片
         */
        this.bcPhotos3 = null;

        /**
         * 档期补差3-检核结果
         */
        this.bcRiskR3 = null;

        /**
         * 虎皮210g价格
         */
        this.priceHp210 = null;

        /**
         * 虎皮210g口味铺市月份
         */
        this.kwYmHp210 = null;

        /**
         * 虎皮105g价格
         */
        this.priceHp105 = null;

        /**
         * 虎皮105g口味铺市月份
         */
        this.kwYmHp105 = null;

        /**
         * 虎皮68g价格
         */
        this.priceHp68 = null;

        /**
         * 虎皮68g口味铺市月份
         */
        this.kwYmHp68 = null;

        /**
         * 鸡肉豆堡120g价格
         */
        this.priceJrdb120 = null;

        /**
         * 鸡肉豆堡120g口味铺市月份
         */
        this.kwYmJrdb120 = null;

        /**
         * 牛肉豆堡120g价格
         */
        this.priceNrdb120 = null;

        /**
         * 牛肉豆堡120g口味铺市月份
         */
        this.kwYmNrdb120 = null;

        /**
         * 去骨凤爪72g价格
         */
        this.priceQg72 = null;

        /**
         * 去骨凤爪72g口味铺市月份
         */
        this.kwYmQg72 = null;

        /**
         * 去骨凤爪138g价格
         */
        this.priceQg138 = null;

        /**
         * 去骨凤爪138g口味铺市月份
         */
        this.kwYmQg138 = null;

        /**
         * 虎皮小鸡腿80g价格
         */
        this.priceHpjt80 = null;

        /**
         * 虎皮小鸡腿80g口味铺市月份
         */
        this.kwYmHpjt80 = null;

        /**
         * 老卤价格
         */
        this.priceLl = null;

        /**
         * 老卤口味铺市月份
         */
        this.kwYmLl = null;

        /**
         * 虎皮单支价格
         */
        this.priceHpDz = null;

        /**
         * 虎皮单支口味铺市月份
         */
        this.kwYmHpDz = null;

        /**
         * 虎皮散称价格
         */
        this.priceHpSc = null;

        /**
         * 虎皮散称口味铺市月份
         */
        this.kwYmHpSc = null;

    }

}