package com.sfa.operation.strategy.impl.exports;

import com.alibaba.nacos.plugin.auth.spi.client.ClientAuthPluginManager;
import com.sfa.operation.config.ExportColumnConfig;
import com.sfa.operation.domain.sales.entity.SalesApSnacksDisplay;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.sales.IApDisplayQueryService;
import com.sfa.operation.strategy.IExportApExcelStrategy;
import com.sfa.operation.util.excel.ExcelStyleUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @Author: DouXinYu
 * @Date: 2025-12-16 15:49
 * @Description: 零食陈列导出策略实现类
 */

@Component("snackDisplayExportStrategy")
public class SnackDisplayExportStrategyImpl implements IExportApExcelStrategy {

    private static final String SNACK_FILE_NAME_PREFIX = "零食陈列";
    private static final String SNACK_SHEET_NAME = "零食陈列";

    @Autowired
    private IApDisplayQueryService apDisplayQueryService;

    @Override
    public List<ExportColumnConfig> getExportColumnConfig() {
        List<ExportColumnConfig> column = new ArrayList<>();

        //特殊限制列处理

        //实际陈列形式
        ExportColumnConfig actualDisplay = new ExportColumnConfig("actualDisplay", "陈列形式(实际)", "", ExcelStyleUtils.ExcelStyle.LIGHT_BLUE_BG);
        actualDisplay.setValidationValidOptions(Arrays.asList("执行与计划一致","执行与计划不一致"));
        actualDisplay.setValidationErrorTitle("输入错误");
        actualDisplay.setValidationPromptMsg("陈列形式（实际）必须输入“执行与计划一致”或“执行与计划不一致”！");
        actualDisplay.setConditionalStyling(true);

        //实际端架数量
        ExportColumnConfig actualEndCapQty = new ExportColumnConfig("actualEndCapQty", "端架数量（计划）", "", ExcelStyleUtils.ExcelStyle.LIGHT_BLUE_BG);
        actualDisplay.setValidationValidOptions(Arrays.asList("0","0.5","1","2"));
        actualDisplay.setValidationErrorTitle("输入错误");
        actualDisplay.setValidationErrorMsg("端架数量（实际）必须是“0、0.5、1、2”之一！");
        actualDisplay.setConditionalStyling(true);



        column.add(new ExportColumnConfig("sasdId", "程序编号-请忽略", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("salesMonth", "计划月份", "YYYY-MM", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("regionName", "销售大区", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("districtName", "销售战区", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("dealerCode", "经销商代码", "@", ExcelStyleUtils.ExcelStyle.CHANGE_TEXT_STYLE));
        column.add(new ExportColumnConfig("dealerName", "经销商名称", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("storeCode",  "门店编码", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("storeName", "门店名称", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("lineName", "系统名称", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("plannedDisplay","陈列形式（计划）","", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(actualDisplay);
        column.add(new ExportColumnConfig("plannedEndCapQty","端架数量（计划）","", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(actualEndCapQty);
        column.add(new ExportColumnConfig("remark","备注","",ExcelStyleUtils.ExcelStyle.DEFAULT_STYLE));


        return column;
    }

    @Override
    public List<SalesApSnacksDisplay> queryData(SalesApRequest salesApRequest) {
        return apDisplayQueryService.querySnackByCondition(salesApRequest);
    }

    @Override
    public String getExportSheetName() {
        return SNACK_SHEET_NAME;
    }

    @Override
    public String getExportFileNamePrefix() {
        return SNACK_FILE_NAME_PREFIX;
    }
}
