package com.sfa.operation.controller.sales.query;

import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.security.annotation.SalesPermissionCheck;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.sales.IApDisplayQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2025-09-08 13
 * @describe :营销中心-活动计划
 * 常规陈列
 * 档期陈列
 * 零食陈列
 * 三米两秒
 * 六小金刚
 */
@RestController
public class ApDisplayQueryController {
    @Autowired
    private IApDisplayQueryService apDisplayQueryService;

    /**
     * 常规陈列
     */
    @GetMapping("/sales/ap_display/query/page")
    @SalesPermissionCheck(value = SalesPermissionCheck.CheckType.USER)
    public PageInfo page(SalesApRequest salesApRequest){
        return apDisplayQueryService.page(salesApRequest);
    }

    /**
     * 档期陈列
     */
    @GetMapping("/sales/ap_display/query/pro_page")
    @SalesPermissionCheck(value = SalesPermissionCheck.CheckType.USER)
    public PageInfo proPage(SalesApRequest salesApRequest){
        return apDisplayQueryService.proPage(salesApRequest);
    }

    /**
     * 零食陈列
     */
    @GetMapping("/sales/ap_display/query/snack_page")
    @SalesPermissionCheck(value = SalesPermissionCheck.CheckType.USER)
    public PageInfo snackPage(SalesApRequest salesApRequest){
        return apDisplayQueryService.snackPage(salesApRequest);
    }

    /**
     * 三米两秒
     */
    @GetMapping("/sales/ap_display/query/sl_page")
    @SalesPermissionCheck(value = SalesPermissionCheck.CheckType.USER)
    public PageInfo slPage(SalesApRequest salesApRequest){
        return apDisplayQueryService.slPage(salesApRequest);
    }

    /**
     * 六小金刚
     */
    @GetMapping("/sales/ap_display/query/jg_page")
    @SalesPermissionCheck(value = SalesPermissionCheck.CheckType.USER)
    public PageInfo jgPage(SalesApRequest salesApRequest){
        return apDisplayQueryService.jgPage(salesApRequest);
    }

    /**
     * 档期计划
     */
    @GetMapping("/sales/ap_promotion/query/page")
    @SalesPermissionCheck(value = SalesPermissionCheck.CheckType.USER)
    public PageInfo promotionPage(SalesApRequest salesApRequest){
        return apDisplayQueryService.promotionPage(salesApRequest);
    }
}
