package com.sfa.operation.domain.qc.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.operation.domain.qc.dao.IQinceClienteleStoreDao;
import com.sfa.operation.domain.qc.entity.QinceClienteleStore;
import com.sfa.operation.domain.qc.mapper.QinceClienteleStoreMapper;
import com.sfa.operation.domain.qc.wq.QcStoreWq;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2025-08-27 16
 * @describe :
 */
@DS("promotion")
@Service
public class QinceClienteleStoreDaoImpl implements IQinceClienteleStoreDao {
    @Autowired
    private QinceClienteleStoreMapper qinceClienteleStoreMapper;

    @Override
    public PageInfo page(QcStoreWq wq) {
        LambdaQueryWrapper<QinceClienteleStore> lqw = builderWq(wq);
        Page<QinceClienteleStore> pageI = TableSupport.pageI();
        Page<QinceClienteleStore> qinceClienteleStorePage = qinceClienteleStoreMapper.selectPage(pageI, lqw);
        PageInfo<QinceClienteleStore> pageInfo = new PageInfo<>(qinceClienteleStorePage);
        return pageInfo;
    }

    private LambdaQueryWrapper<QinceClienteleStore> builderWq(QcStoreWq wq) {
        LambdaQueryWrapper<QinceClienteleStore> qw = new LambdaQueryWrapper<>();
        // 根据名称、编码模糊查询
        if (StringUtils.isNotBlank(wq.getCol())) {
            qw.eq(QinceClienteleStore::getStoreCode, wq.getCol()).or().like(QinceClienteleStore::getStoreName, wq.getCol());
        }
        qw.select(QinceClienteleStore::getQcId, QinceClienteleStore::getStoreCode, QinceClienteleStore::getStoreName, QinceClienteleStore::getDealerId, QinceClienteleStore::getDealersName, QinceClienteleStore::getStorePictures);
        return qw;
    }
}
