package com.sfa.operation.service.impl;

import cn.hutool.core.date.DateTime;
import com.sfa.operation.domain.dao.ISfaKqmxDao;
import com.sfa.operation.pojo.response.SfaKqMxDto;
import com.sfa.operation.service.IKqMxQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2024-11-05 14
 * @describe :
 */
@Service
public class KqMxQueryServiceImpl implements IKqMxQueryService {
    @Autowired
    ISfaKqmxDao sfaKqmxDao;

    @Override
    public Map rollDateList(DateTime dateTime,Long userId) {
        List<SfaKqMxDto> dtos = sfaKqmxDao.betweentDate(dateTime,userId);
        TreeMap<Date, List<SfaKqMxDto>> collect = dtos.stream().collect(Collectors.groupingBy(SfaKqMxDto::getCreateDate, TreeMap::new, Collectors.toList()));
        return collect.descendingMap();
    }
}
