package com.sfa.operation.controller.sales.query;

import com.sfa.common.core.constant.RoleConstants;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.security.annotation.RequiresPermissions;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.config.ConstantValue;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.qc.IQinceMarketEmployeeService;
import com.sfa.operation.service.sales.IApDisplayQueryService;
import com.sfa.system.api.domain.SysRole;
import com.sfa.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

/**
 * @author : liqiulin
 * @date : 2025-09-08 13
 * @describe :营销中心-活动计划
 * 常规陈列
 * 档期陈列
 * 零食陈列
 * 三米两秒
 * 六小金刚
 */
@RestController
public class ApDisplayQueryController {
    @Autowired
    private IApDisplayQueryService apDisplayQueryService;
    @Autowired
    private IQinceMarketEmployeeService qinceMarketEmployeeService;
    @Autowired
    private ConstantValue constantValue;

    /**
     * 常规陈列
     */
    @GetMapping("/sales/ap_display/query/page")
    public PageInfo page(SalesApRequest salesApRequest){
        checkPermission(salesApRequest);
        return apDisplayQueryService.page(salesApRequest);
    }

    /**
     * 档期陈列
     */
    @GetMapping("/sales/ap_display/query/pro_page")
    public PageInfo proPage(SalesApRequest salesApRequest){
        checkPermission(salesApRequest);
        return apDisplayQueryService.proPage(salesApRequest);
    }

    /**
     * 零食陈列
     */
    @GetMapping("/sales/ap_display/query/snack_page")
    public PageInfo snackPage(SalesApRequest salesApRequest){
        checkPermission(salesApRequest);
        return apDisplayQueryService.snackPage(salesApRequest);
    }

    /**
     * 三米两秒
     */
    @GetMapping("/sales/ap_display/query/sl_page")
    public PageInfo slPage(SalesApRequest salesApRequest){
        checkPermission(salesApRequest);
        return apDisplayQueryService.slPage(salesApRequest);
    }

    /**
     * 六小金刚
     */
    @GetMapping("/sales/ap_display/query/jg_page")
    public PageInfo jgPage(SalesApRequest salesApRequest){
        checkPermission(salesApRequest);
        return apDisplayQueryService.jgPage(salesApRequest);
    }

    /**
     * 档期计划
     */
    @GetMapping("/sales/ap_promotion/query/page")
    public PageInfo promotionPage(SalesApRequest salesApRequest){
        checkPermission(salesApRequest);
        return apDisplayQueryService.promotionPage(salesApRequest);
    }

    /**
     * 判断登录人权限
     * 判断是否存在人客关系，存在：根据负责经销商查询数据；不存在：判断是否是销售部人员。是：根据部门查询；不是：返回全部数据
     */
    private void checkPermission(SalesApRequest salesApRequest) {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        String ancestors = loginUser.getSysUser().getDept().getAncestors();
        List<SysRole> roles = loginUser.getSysUser().getRoles();

        // 不是区域销售部的人员，可以查看所有
        if (!ancestors.contains(constantValue.deptYX) && roles.stream().filter(role -> RoleConstants.OPERATION_CENTER_AP_MANAGER.equals(role.getRoleKey())).findFirst().isPresent()) {
            return;
        }

        // 是区域销售部的人员：1、销售查看人客关系；2、大区TM查看当前部门下所有数据
        // 判断是否是大区TM
        String empNo = loginUser.getUsername();
        Optional<SysRole> first = roles.stream().filter(role -> RoleConstants.DISTRICT_AP_MANAGER.equals(role.getRoleKey())).findFirst();
        if (first.isPresent()) {
            ArrayList<String> deptNames = new ArrayList<>();
            deptNames.add(loginUser.getSysUser().getDept().getDeptNameSale());
            if ("000889".equals(empNo)){
                deptNames.add("北京特区");
            }
            return;
        }
        // 不是大区TM，判断是否是销售人员(人客关系)
        List<String> dealerCodes = qinceMarketEmployeeService.checkPermission(empNo);
        if (dealerCodes.isEmpty()) {
            throw new CheckedException(ECode.QC_MARKET_EMP_ERROR);
        }
//        salesApRequest.setNickName(loginUser.getNickName());
        salesApRequest.setDealerCodes(dealerCodes);
    }
}
