package com.sfa.operation.domain.sales.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.core.utils.DateUtils;
import com.sfa.common.core.utils.StringUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.operation.domain.sales.dao.ISalesApDisplayJDao;
import com.sfa.operation.domain.sales.entity.SalesApDisplayJ;
import com.sfa.operation.domain.sales.mapper.SalesApDisplayJMapper;
import com.sfa.operation.domain.sales.wq.SalesApWq;
import com.sfa.operation.pojo.sales.response.SalesApDisplayJDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-11-21 14
 * @describe :
 */
@DS("bi")
@Service
public class SalesApDisplayJDaoImpl implements ISalesApDisplayJDao {
    @Autowired
    private SalesApDisplayJMapper salesApDisplayJMapper;

    @Override
    public PageInfo page(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApDisplayJ> qw = buildWq(salesApWq);
        Page<SalesApDisplayJ> salesApDisplayJPage = salesApDisplayJMapper.selectPage(TableSupport.pageI(), qw);
        return new PageInfo<>(salesApDisplayJPage);
    }

    @Override
    public void updateDetail(SalesApDisplayJDto djDto) {
        SalesApDisplayJ salesApDisplayJ = salesApDisplayJMapper.selectById(djDto.getSadjId());
        // 判断salesMonth是否是当前月份
        if (!DateUtils.isSameYearMonth(salesApDisplayJ.getSalesMonth(),new Date())){
            throw new CheckedException(ECode.SALES_AP_UPDATE_ERROR);
        }
        SalesApDisplayJ entity = new SalesApDisplayJ();
        BeanUtils.copyProperties(djDto, entity);
        salesApDisplayJMapper.updateById(entity);
    }


    private LambdaQueryWrapper<SalesApDisplayJ> buildWq(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApDisplayJ> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(salesApWq.getSalesMonth())){
            qw.eq(SalesApDisplayJ::getSalesMonth, salesApWq.getSalesMonth());
        }
        if (StringUtils.isNotBlank(salesApWq.getRqStatus())){
            qw.eq(SalesApDisplayJ::getGwExecuted6, salesApWq.getRqStatus());
        }
        if (!CollectionUtils.isEmpty(salesApWq.getDealerCodes())) {
            qw.in(SalesApDisplayJ::getDealerCode, salesApWq.getDealerCodes());
        }
        if (!CollectionUtils.isEmpty(salesApWq.getDeptNames())){
            qw.and(
                    wrapper -> wrapper.in(SalesApDisplayJ::getRegionName, salesApWq.getDeptNames())
                            .or()
                            .in(SalesApDisplayJ::getDistrictName, salesApWq.getDeptNames())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getNickName())){
            qw.and(
                    wrapper -> wrapper.eq(SalesApDisplayJ::getRegionManager, salesApWq.getNickName())
                            .or()
                            .eq(SalesApDisplayJ::getDistrictManager, salesApWq.getNickName())
                            .or()
                            .eq(SalesApDisplayJ::getCityManager, salesApWq.getNickName())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getDealerCN())){
            qw.and(
                    wrapper -> wrapper.like(SalesApDisplayJ::getDealerName, salesApWq.getDealerCN())
                            .or()
                            .like(SalesApDisplayJ::getDealerCode, salesApWq.getDealerCN())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getStoreCN())){
            qw.and(
                    wrapper -> wrapper.like(SalesApDisplayJ::getStoreName, salesApWq.getStoreCN())
                            .or()
                            .like(SalesApDisplayJ::getStoreCode, salesApWq.getStoreCN())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getLineNameLike())){
            qw.like(SalesApDisplayJ::getLineName, salesApWq.getLineNameLike());
        }
        return qw;
    }
}
