package com.sfa.operation.controller.sales.core;

import com.sfa.common.core.constant.RoleConstants;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.security.annotation.Logical;
import com.sfa.common.security.annotation.RequiresRoles;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.qc.IQinceMarketEmployeeService;
import com.sfa.operation.service.sales.IApDisplayCoreService;
import com.sfa.system.api.domain.SysRole;
import com.sfa.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

/**
 * @author : liqiulin
 * @date : 2025-09-16 15
 * @describe : 常规陈列、档期陈列、零食陈列
 */
@RestController
public class ApDisplayCoreController {
    @Autowired
    private IApDisplayCoreService apDisplayCoreService;

    /**
     * 常规陈列 根据id更新
     */
    @PutMapping("/sales/ap_display/core/{id}")
    @RequiresRoles(value = {RoleConstants.OPERATION_AP_MANAGER, RoleConstants.OPERATIONZQ_AP_MANAGER, RoleConstants.OPERATIONDQ_AP_MANAGER, RoleConstants.DISTRICT_AP_MANAGER}, logical = Logical.OR)
    public void putDetail(@PathVariable("id") Long sadId, @RequestBody SalesApRequest request){
//        checkPermission();
        request.setSadId(sadId);
        apDisplayCoreService.updateDetail(request);
    }

    /**
     * 档期陈列 根据id更新
     */
    @PutMapping("/sales/ap_display/core_pro/{id}")
    @RequiresRoles(value = {RoleConstants.OPERATION_AP_MANAGER, RoleConstants.OPERATIONZQ_AP_MANAGER, RoleConstants.OPERATIONDQ_AP_MANAGER, RoleConstants.DISTRICT_AP_MANAGER}, logical = Logical.OR)
    public void putProDisplayDetail(@PathVariable("id") Long sapdId, @RequestBody SalesApRequest request){
//        checkPermission();
        request.setSapdId(sapdId);
        apDisplayCoreService.putProDisplayDetail(request);
    }

    /**
     * 零食陈列 根据id更新
     */
    @PutMapping("/sales/ap_display/core_snack/{id}")
    @RequiresRoles(value = {RoleConstants.OPERATION_AP_MANAGER, RoleConstants.OPERATIONZQ_AP_MANAGER, RoleConstants.OPERATIONDQ_AP_MANAGER, RoleConstants.DISTRICT_AP_MANAGER}, logical = Logical.OR)
    public void putSnackDisplayDetail(@PathVariable("id") Long sasdId, @RequestBody SalesApRequest request){
//        checkPermission();
        request.setSasdId(sasdId);
        apDisplayCoreService.putSnackDisplayDetail(request);
    }

    /**
     * 三米两秒
     */
    @PutMapping("/sales/ap_display/core_s/{id}")
    @RequiresRoles(value = {RoleConstants.OPERATION_AP_MANAGER, RoleConstants.OPERATIONZQ_AP_MANAGER, RoleConstants.OPERATIONDQ_AP_MANAGER, RoleConstants.DISTRICT_AP_MANAGER}, logical = Logical.OR)
    public void putDisplaySDetail(@PathVariable("id") Long sadsId, @RequestBody SalesApRequest request){
//        checkPermission();
        request.setSadsId(sadsId);
        apDisplayCoreService.putDisplaySDetail(request);
    }

    /**
     * 六小金刚
     */
    @PutMapping("/sales/ap_display/core_j/{id}")
    @RequiresRoles(value = {RoleConstants.OPERATION_AP_MANAGER, RoleConstants.OPERATIONZQ_AP_MANAGER, RoleConstants.OPERATIONDQ_AP_MANAGER, RoleConstants.DISTRICT_AP_MANAGER}, logical = Logical.OR)
    public void putDisplayJDetail(@PathVariable("id") Long sadjId, @RequestBody SalesApRequest request){
//        checkPermission();
        request.setSadjId(sadjId);
        apDisplayCoreService.putDisplayJDetail(request);
    }

    /**
     * 更新AP促销计划详情
     * 大区总、战区经理、城市经理、TM，可以更新
     */
    @PutMapping("/sales/ap_promotion/core/{id}")
    @RequiresRoles(value = {RoleConstants.OPERATION_AP_MANAGER, RoleConstants.OPERATIONZQ_AP_MANAGER, RoleConstants.OPERATIONDQ_AP_MANAGER, RoleConstants.DISTRICT_AP_MANAGER}, logical = Logical.OR)
    public void putPromotionDetail(@PathVariable("id") Long sapId, @RequestBody SalesApRequest request) {
//        checkPermission();
        request.setSapId(sapId);
        apDisplayCoreService.putPromotionDetail(request);
    }


//    @Autowired
//    private IQinceMarketEmployeeService qinceMarketEmployeeService;

//    private void checkPermission(){
//        // 是区域销售部的人员，查看人客关系
//        LoginUser loginUser = SecurityUtils.getLoginUser();
//        // 只有销售（促销AP管理：cxapgl）、大区TM（大区TM促销AP管理：dqtmcxapgl）两种角色才可以修改
//        List<SysRole> roles = loginUser.getSysUser().getRoles();
//        Optional<SysRole> first = roles.stream().filter(role -> RoleConstants.DISTRICT_AP_MANAGER.equals(role.getRoleKey()) || RoleConstants.OPERATION_AP_MANAGER.equals(role.getRoleKey())).findFirst();
//        if (!first.isPresent()) {
//            throw new CheckedException(ECode.ZZ_PRODUCT_QUALITY_AP_ERROR);
//        }
//
////        String empNo = loginUser.getUsername();
////        List<String> dealerCodes = qinceMarketEmployeeService.checkPermission(empNo);
////        if (dealerCodes.isEmpty()){
////            throw new CheckedException(ECode.QC_MARKET_EMP_ERROR);
////        }
//    }

}
