package com.sfa.operation.service.sales;

import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.operation.domain.sales.entity.SalesApDisplay;
import com.sfa.operation.domain.sales.entity.SalesApPromotion;
import com.sfa.operation.domain.sales.entity.SalesApSnacksDisplay;
import com.sfa.operation.pojo.sales.excel.SalesApDisplayImportExcelDto;
import com.sfa.operation.pojo.sales.request.SalesApRequest;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-09-08 14
 * @describe :
 */
public interface IApDisplayQueryService {
    PageInfo page(SalesApRequest salesApRequest);

    PageInfo proPage(SalesApRequest salesApRequest);

    PageInfo snackPage(SalesApRequest salesApRequest);

    PageInfo slPage(SalesApRequest salesApRequest);

    PageInfo jgPage(SalesApRequest salesApRequest);

    PageInfo promotionPage(SalesApRequest salesApRequest);

    Object queryStoreAPReport(SalesApRequest request);

    Object queryDeptAPReport(SalesApRequest request);

    Object queryDistAPReport(SalesApRequest request);
    List<SalesApDisplay> queryDataListByCondition(SalesApRequest build);
    List<SalesApDisplay> queryByCondition(List<SalesApDisplayImportExcelDto> queryParam);

    /**
     * 导出 - 根据条件查询零食陈列
     * @param salesApRequest 查询条件
     * @return 返回根据条件查询的结果列表
     */
    List<SalesApSnacksDisplay> querySnackByCondition(SalesApRequest salesApRequest);

    /**
     * 导出- 根据条件查询数据结果集
     * @param salesApRequest 查询条件
     * @return 返回根据条件查询的结果列表
     */
    List<SalesApPromotion> queryPromotionDisplayByCondition(SalesApRequest salesApRequest);
}
