package com.sfa.operation.domain.sales.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.core.utils.DateUtils;
import com.sfa.common.core.utils.StringUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.operation.domain.sales.dao.ISalesApPromotionDao;
import com.sfa.operation.domain.sales.entity.SalesApPromotion;
import com.sfa.operation.domain.sales.mapper.SalesApPromotionMapper;
import com.sfa.operation.domain.sales.wq.SalesApWq;
import com.sfa.operation.pojo.sales.response.SalesApPromotionDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-09-17 15
 * @describe :
 */
@DS("bi")
@Service
public class SalesApPromotionImplDao implements ISalesApPromotionDao {
    @Autowired
    private SalesApPromotionMapper salesApPromotionMapper;

    @Override
    public PageInfo page(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApPromotion> qw = buildWq(salesApWq);
        Page<SalesApPromotion> salesApDisplayPage = salesApPromotionMapper.selectPage(TableSupport.pageI(), qw);
        return new PageInfo(salesApDisplayPage);
    }

    @Override
    public void updateById(SalesApPromotionDto dto) {
        SalesApPromotion entityOld = salesApPromotionMapper.selectById(dto.getSapId());
        if (!DateUtils.isSameYearMonth(entityOld.getSalesMonth(),new Date())){
            throw new CheckedException(ECode.SALES_AP_UPDATE_ERROR);
        }
        // 实际-档期开始/结束时间，是否在当月或下月内
        if (dto.getIsActualPromotionStartDate() || dto.getIsActualPromotionEndDate()){
            if (dto.getIsActualPromotionStartDate() && Objects.nonNull(dto.getActualPromotionStartDate())){
                Date plansDate = entityOld.getPlannedPromotionStartDate();
                Date sDate = dto.getActualPromotionStartDate();
                if (!(DateUtils.isSameYearMonth(sDate,plansDate) || DateUtils.isNextMonth(plansDate,sDate))){
                    throw new CheckedException(ECode.SAP_EXECUTE_MONTH_ERROR);
                }
            }
            if (dto.getIsActualPromotionEndDate() && Objects.nonNull(dto.getActualPromotionEndDate())){
                Date plansDate = entityOld.getPlannedPromotionEndDate();
                Date sDate = dto.getActualPromotionEndDate();
                if (!(DateUtils.isSameYearMonth(sDate,plansDate) || DateUtils.isNextMonth(plansDate,sDate))){
                    throw new CheckedException(ECode.SAP_EXECUTE_MONTH_ERROR);
                }
            }
        }

        SalesApPromotion salesApPromotion = new SalesApPromotion();
        BeanUtils.copyProperties(dto, salesApPromotion);
        salesApPromotionMapper.putById(salesApPromotion);
    }

    /**
     * 导出 - 根据条件查询导出数据
     * @param build 条件
     * @return  查询结果列表
     */
    @Override
    public List<SalesApPromotion> queryPromotionDisplayByCondition(SalesApWq build) {
        LambdaQueryWrapper<SalesApPromotion> queryWrapper = buildWq(build);
        return salesApPromotionMapper.selectList(queryWrapper);
    }

    private LambdaQueryWrapper<SalesApPromotion> buildWq(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApPromotion> qw = new LambdaQueryWrapper<>();
        if (StringUtils.isNotBlank(salesApWq.getDealerCode())) {
            qw.eq(SalesApPromotion::getDealerCode, salesApWq.getDealerCode());
        }
        if (!CollectionUtils.isEmpty(salesApWq.getDealerCodes())) {
            qw.in(SalesApPromotion::getDealerCode, salesApWq.getDealerCodes());
        }
        if (StringUtils.isNotBlank(salesApWq.getCityManager())) {
            qw.eq(SalesApPromotion::getCityManager, salesApWq.getCityManager());
        }
        if (Objects.nonNull(salesApWq.getSalesMonth())){
            qw.eq(SalesApPromotion::getSalesMonth, salesApWq.getSalesMonth());
        }
        if (!CollectionUtils.isEmpty(salesApWq.getDeptNames())){
            qw.and(
                    wrapper -> wrapper.in(SalesApPromotion::getRegionName, salesApWq.getDeptNames())
                            .or()
                            .in(SalesApPromotion::getDistrictName, salesApWq.getDeptNames())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getDeptName())) {
            qw.and(
                    wrapper -> wrapper.like(SalesApPromotion::getRegionName, salesApWq.getDeptName())
                            .or()
                            .like(SalesApPromotion::getDistrictName, salesApWq.getDeptName())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getNickName())){
            qw.and(
                    wrapper -> wrapper.eq(SalesApPromotion::getRegionManager, salesApWq.getNickName())
                            .or()
                            .eq(SalesApPromotion::getDistrictManager, salesApWq.getNickName())
                            .or()
                            .eq(SalesApPromotion::getCityManager, salesApWq.getNickName())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getDealerCN())){
            qw.and(
                    wrapper -> wrapper.like(SalesApPromotion::getDealerName, salesApWq.getDealerCN())
                            .or()
                            .like(SalesApPromotion::getDealerCode, salesApWq.getDealerCN())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getRqStatus())){
            qw.and(
                    wrapper -> wrapper.eq(SalesApPromotion::getSpecExecutionStatus, salesApWq.getRqStatus())
                            .or()
                            .eq(SalesApPromotion::getFlavorExecutionStatus, salesApWq.getRqStatus())
                            .or()
                            .eq(SalesApPromotion::getPromotionImplementationStatus, "否")
                            .or()
                            .eq(SalesApPromotion::getPromotionPriceExecutionStatus, salesApWq.getRqStatus())
                            .or()
                            .eq(SalesApPromotion::getPosterExecutionStatus, salesApWq.getRqStatus())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getLineNameLike())){
            qw.like(SalesApPromotion::getLineName, salesApWq.getLineNameLike());
        }
        return qw;
    }
}
