package com.sfa.operation.controller.sales.query;

import com.sfa.common.core.constant.RoleConstants;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.config.ConstantValue;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.qc.IQinceMarketEmployeeService;
import com.sfa.operation.service.sales.IApPromotionQueryService;
import com.sfa.system.api.domain.SysRole;
import com.sfa.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;

/**
 * @author : liqiulin
 * @date : 2025-09-17 15
 * @describe : 档期计划
 */
@RestController
@RequestMapping("/sales/ap_promotion/query")
public class ApPromotionQueryController {
    @Autowired
    private IApPromotionQueryService apPromotionQueryService;
    @Autowired
    private IQinceMarketEmployeeService qinceMarketEmployeeService;
    @Autowired
    private ConstantValue constantValue;

    @GetMapping("/page")
    public PageInfo page(SalesApRequest salesApRequest){
        checkPermission(salesApRequest);
        return apPromotionQueryService.page(salesApRequest);
    }


    /**
     * 判断登录人权限
     * 判断是否存在人客关系，存在：根据负责经销商查询数据；不存在：判断是否是销售部人员。是：根据部门查询；不是：返回全部数据
     */
    private void checkPermission(SalesApRequest salesApRequest) {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        String ancestors = loginUser.getSysUser().getDept().getAncestors();
        // 不是区域销售部的人员，可以查看所有
        if (!ancestors.contains(constantValue.deptYX)) {
            return;
        }

        // 是区域销售部的人员：1、销售查看人客关系；2、大区TM查看当前部门下所有数据
        // 判断是否是大区TM
        List<SysRole> roles = loginUser.getSysUser().getRoles();
        Optional<SysRole> first = roles.stream().filter(role -> RoleConstants.DISTRICT_AP_MANAGER.equals(role.getRoleKey())).findFirst();
        if (first.isPresent()) {
            String deptName = loginUser.getSysUser().getDept().getDeptName();
            salesApRequest.setDeptName(deptName);
            return;
        }
        // 不是大区TM，判断是否是销售人员
        String empNo = loginUser.getUsername();
        List<String> dealerCodes = qinceMarketEmployeeService.checkPermission(empNo);

        // 没有人客关系
        if (dealerCodes.isEmpty()) {
            throw new CheckedException(ECode.QC_MARKET_EMP_ERROR);
//            String deptName = loginUser.getSysUser().getDept().getDeptName();
//            salesApRequest.setDeptName(deptName);
//            return;
        }
        // 有人客关系，根据负责经销商查询
        salesApRequest.setDealerCodes(dealerCodes);
    }
}
