package com.sfa.operation.domain.sales.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.core.utils.DateUtils;
import com.sfa.common.core.utils.StringUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.operation.domain.sales.dao.ISalesApDisplayDao;
import com.sfa.operation.domain.sales.entity.SalesApDisplay;
import com.sfa.operation.domain.sales.mapper.SalesApDisplayMapper;
import com.sfa.operation.domain.sales.wq.SalesApWq;
import com.sfa.operation.pojo.sales.excel.SalesApDisplayImportExcelDto;
import com.sfa.operation.pojo.sales.response.SalesApDisplayDto;
import com.sfa.operation.util.excel.EntityUpdateCheckUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.function.Consumer;

/**
 * @author : liqiulin
 * @date : 2025-09-08 14
 * @describe :
 */
@DS("bi")
@Service
public class SalesApDisplayDaoImpl implements ISalesApDisplayDao  {

    @Autowired
    private SalesApDisplayMapper salesapdisMapper;
    @Override
    public PageInfo page(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApDisplay> qw = buildWq(salesApWq);
        Page<SalesApDisplay> salesApDisplayPage = salesapdisMapper.selectPage(TableSupport.pageI(), qw);
        PageInfo pageInfo = new PageInfo(salesApDisplayPage);
        return pageInfo;
    }

    @Override
    public void updateDetail(SalesApDisplayDto salesApDisplayDto) {
        SalesApDisplay salesApDisplay = salesapdisMapper.selectById(salesApDisplayDto.getSadId());
        if (!DateUtils.isSameYearMonth(salesApDisplay.getSalesMonth(),new Date())){
            throw new CheckedException(ECode.SALES_AP_UPDATE_ERROR);
        }
        SalesApDisplay updateDo = new SalesApDisplay();
        BeanUtils.copyProperties(salesApDisplayDto,updateDo);
        salesapdisMapper.updateById(updateDo);
    }

    @Override
    public Object queryStoreAPReport(SalesApWq build) {
        return salesapdisMapper.queryStoreAPReport(build);
    }

    @Override
    public Object queryDeptAPReport(SalesApWq build) {
        List<Map<String, Object>> mapZ = salesapdisMapper.queryDeptAPReportZQ(build);
        List<Map<String, Object>> mapD = salesapdisMapper.queryDeptAPReportDQ(build);
        List<Map<String, Object>> mapHZ = salesapdisMapper.queryDeptAPHZReportDQ(build);
        Map<String,Object> r = new HashMap<>();
        r.put("zq",mapZ);
        r.put("dq",mapD);
        r.put("hz",mapHZ);
        return r;

    }

    @Override
    public Object queryDistAPReport(SalesApWq build) {
        List<Map<String, Object>> mapDist = salesapdisMapper.queryDistAPReport(build);
        List<Map<String, Object>> mapDistHz = salesapdisMapper.queryDistAPHZReport(build);
        Map<String,Object> r = new HashMap<>();
        r.put("dist",mapDist);
        r.put("hz",mapDistHz);
        return r;
    }

    @Override
    public List<SalesApDisplay> queryDataListByCondition(SalesApWq build) {
        LambdaQueryWrapper<SalesApDisplay> queryWrapper = buildWq(build);
        List<SalesApDisplay> apDisplayList = salesapdisMapper.selectList(queryWrapper);
        return apDisplayList;
    }

    @Override
    public List<SalesApDisplay> queryByCondition(List<SalesApDisplayImportExcelDto> validDtoList) {
        // 构建精准匹配的QueryWrapper（每个DTO对应一组AND条件，组间OR连接）
        QueryWrapper<SalesApDisplay> wrapper = new QueryWrapper<>();
        // 标记是否是第一个OR条件（避免多余的前置OR）
        boolean isFirstCondition = true;
        for (SalesApDisplayImportExcelDto dto : validDtoList) {
            // 字段为空时不参与条件匹配（或根据业务要求改为IS NULL）
            Long sadId = dto.getSadId();
            String regionName = StringUtils.trimToNull(dto.getRegionName());
            String dealerName = StringUtils.trimToNull(dto.getDealerName());
            String lineName = StringUtils.trimToNull(dto.getLineName());

            // 构建单DTO的AND组合条件
            Consumer<QueryWrapper<SalesApDisplay>> singleDtoCondition = w -> {
                w.eq(sadId != null, "sad_id", sadId)
                        .eq(regionName != null, "region_name", regionName)
                        .eq(dealerName != null, "dealer_name", dealerName)
                        .eq(lineName != null, "line_name", lineName);
            };

            // 多条件OR拼接（第一个条件不加OR，避免SQL语法错误）
            if (isFirstCondition) {
                singleDtoCondition.accept(wrapper);
                isFirstCondition = false;
            } else {
                wrapper.or(singleDtoCondition);
            }
        }
        return salesapdisMapper.selectList(wrapper);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean batchUpdate(List<SalesApDisplay> updateEntityList) {
        int affectRows = 0;
        List<List<SalesApDisplay>> batchList = EntityUpdateCheckUtil.splitList(updateEntityList, 1000);
        for (List<SalesApDisplay> batch : batchList) {
            // 批量更新
            affectRows = salesapdisMapper.batchUpdate(batch);
        }
        return affectRows > 0;
    }

    private LambdaQueryWrapper<SalesApDisplay> buildWq(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApDisplay> qw = new LambdaQueryWrapper<>();
        if (StringUtils.isNotBlank(salesApWq.getDealerCode())) {
            qw.eq(SalesApDisplay::getDealerCode, salesApWq.getDealerCode());
        }
        if (!CollectionUtils.isEmpty(salesApWq.getDealerCodes())) {
            qw.in(SalesApDisplay::getDealerCode, salesApWq.getDealerCodes());
        }
        if (StringUtils.isNotBlank(salesApWq.getCityManager())) {
            qw.eq(SalesApDisplay::getCityManager, salesApWq.getCityManager());
        }
        if (Objects.nonNull(salesApWq.getSalesMonth())){
            qw.eq(SalesApDisplay::getSalesMonth, salesApWq.getSalesMonth());
        }
        if (!CollectionUtils.isEmpty(salesApWq.getDeptNames())){
            qw.and(
                    wrapper -> wrapper.in(SalesApDisplay::getRegionName, salesApWq.getDeptNames())
                            .or()
                            .in(SalesApDisplay::getDistrictName, salesApWq.getDeptNames())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getDeptName())){
            qw.and(
                    wrapper -> wrapper.like(SalesApDisplay::getRegionName, salesApWq.getDeptName())
                            .or()
                            .like(SalesApDisplay::getDistrictName, salesApWq.getDeptName())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getNickName())){
            qw.and(
                    wrapper -> wrapper.eq(SalesApDisplay::getRegionManager, salesApWq.getNickName())
                            .or()
                            .eq(SalesApDisplay::getDistrictManager, salesApWq.getNickName())
                            .or()
                            .eq(SalesApDisplay::getCityManager, salesApWq.getNickName())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getDealerCN())){
            qw.and(
                    wrapper -> wrapper.like(SalesApDisplay::getDealerName, salesApWq.getDealerCN())
                            .or()
                            .like(SalesApDisplay::getDealerCode, salesApWq.getDealerCN())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getStoreCN())){
            qw.and(
                    wrapper -> wrapper.like(SalesApDisplay::getStoreName, salesApWq.getStoreCN())
                            .or()
                            .like(SalesApDisplay::getStoreCode, salesApWq.getStoreCN())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getRqStatus())){
            qw.and(
                    wrapper -> wrapper.eq(SalesApDisplay::getActualMainShelfExecuted, salesApWq.getRqStatus())
                            .or()
                            .eq(SalesApDisplay::getActualEndCapExecuted, salesApWq.getRqStatus())
                            .or()
                            .eq(SalesApDisplay::getActualFloorStackExecuted, salesApWq.getRqStatus())
                            .or()
                            .eq(SalesApDisplay::getActualMultiDisplayExecuted, salesApWq.getRqStatus())
                            .or()
                            .eq(SalesApDisplay::getHangingStripExecuted, salesApWq.getRqStatus())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getLineNameLike())){
            qw.like(SalesApDisplay::getLineName, salesApWq.getLineNameLike());
        }
        return qw;
    }
}
