package com.sfa.operation.config;

import com.sfa.operation.util.excel.ExcelStyleUtils;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.poi.ss.usermodel.DataValidation;

import java.util.List;

/**
 * @Author: DouXinYu
 * @Date: 2025-12-08 16:43
 * @Description: AP导出列配置
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ExportColumnConfig {
    // 字段名
    private String fieldName;
    // 表头名
    private String headerName;
    // 格式(如：日期 yyyy-mm)
    private String format;
    // 列样式
    private ExcelStyleUtils.ExcelStyle style;
    // 合法值列表（null/空则不验证）
    private List<String> validationValidOptions;
    // 输入提示标题（可选）
    private String validationPromptTitle;
    // 输入提示内容（可选）
    private String validationPromptMsg;
    // 错误提示标题（可选）
    private String validationErrorTitle;
    // 错误提示内容（可选）
    private String validationErrorMsg;
    // 错误级别（默认阻止非法输入）
    private int validationErrorStyle = DataValidation.ErrorStyle.STOP;
    // 验证生效起始行（默认第1行，跳过表头）
    private int validationStartRow = 1;
    private int validationEndRow = 1048575;

    // 数字最小值（null则不限制）
    private Double validationNumberMin;
    // 数字最大值（null则不限制）
    private Double validationNumberMax;
    // 是否允许小数（默认整数）
    private boolean validationNumberAllowDecimal = false;
    // 标记：是否启用数字验证
    private boolean isNumberValidation = false;

    // 标记：是否启用条件样式
    private boolean conditionalStyling = false;

    public ExportColumnConfig(String fieldName, String headerName, String format, ExcelStyleUtils.ExcelStyle style) {
        this.fieldName = fieldName;
        this.headerName = headerName;
        this.format = format;
        this.style = style;
    }

}

