package com.sfa.operation.service.sales.impl;

import com.sfa.operation.domain.sales.dao.ISalesApDisplayDao;
import com.sfa.operation.domain.sales.dao.ISalesApPromotionDisplayDao;
import com.sfa.operation.domain.sales.dao.ISalesApSnacksDisplayDao;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.pojo.sales.response.SalesApDisplayDto;
import com.sfa.operation.pojo.sales.response.SalesApPromotionDisplayDto;
import com.sfa.operation.pojo.sales.response.SalesApSnacksDisplayDto;
import com.sfa.operation.service.sales.IApDisplayCoreService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2025-09-16 16
 * @describe :
 */
@Service
public class ApDisplayCoreServiceImpl implements IApDisplayCoreService {
    @Autowired
    private ISalesApDisplayDao salesApDisplayDao;
    @Autowired
    private ISalesApSnacksDisplayDao salesApSnacksDisplayDao;
    @Autowired
    private ISalesApPromotionDisplayDao salesApPromotionDisplayDao;
    @Override
    public void updateDetail(SalesApRequest request) {
        SalesApDisplayDto salesApDisplayDto = new SalesApDisplayDto();
        BeanUtils.copyProperties(request.getDisplay(), salesApDisplayDto);
        salesApDisplayDto.setSadId(request.getSadId());
        salesApDisplayDao.updateDetail(salesApDisplayDto);
    }

    @Override
    public void putSnackDisplayDetail(SalesApRequest request) {
        SalesApSnacksDisplayDto sdDto = new SalesApSnacksDisplayDto();
        BeanUtils.copyProperties(request.getSnackDisplay(), sdDto);
        sdDto.setSasdId(request.getSasdId());
        salesApSnacksDisplayDao.updateDetail(sdDto);
    }

    @Override
    public void putProDisplayDetail(SalesApRequest request) {
        SalesApPromotionDisplayDto pdDto = new SalesApPromotionDisplayDto();
        BeanUtils.copyProperties(request.getPromotionDisplay(), pdDto);
        pdDto.setSapdId(request.getSapdId());
        salesApPromotionDisplayDao.updateDetail(pdDto);
    }
}
