package com.sfa.operation.controller.sales.query;

import com.sfa.common.core.context.UserRoles;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.security.annotation.RequiresPermissions;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.sales.IApDisplayQueryService;
import com.sfa.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;

/**
 * @author : liqiulin
 * @date : 2025-09-08 13
 * @describe :营销中心-活动计划
 * 常规陈列
 * 档期陈列
 * 零食陈列
 */
@RequiresPermissions("promotion:display_schedule:list")
@RestController
@RequestMapping("/sales/ap_display/query")
public class ApDisplayQueryController {
    @Autowired
    private IApDisplayQueryService apDisplayQueryService;

    /**
     * 常规陈列
     */
//    @RequiresPermissions("promotion:display_schedule:list")
    @GetMapping("/page")
    public PageInfo page(SalesApRequest salesApRequest){
        checkPermission(salesApRequest);
        return apDisplayQueryService.page(salesApRequest);
    }

    /**
     * 档期陈列
     */
//    @RequiresPermissions("promotion:display_schedule:list")
    @GetMapping("/pro_page")
    public PageInfo proPage(SalesApRequest salesApRequest){
        checkPermission(salesApRequest);
        return apDisplayQueryService.proPage(salesApRequest);
    }

    /**
     * 零食陈列
     */
//    @RequiresPermissions("promotion:display_schedule:list")
    @GetMapping("/snack_page")
    public PageInfo snackPage(SalesApRequest salesApRequest){
        checkPermission(salesApRequest);
        return apDisplayQueryService.snackPage(salesApRequest);
    }

    /**
     * 判断登录人权限
     */
    private void checkPermission(SalesApRequest salesApRequest){
        // 判断登录人权限
        LoginUser loginUser = SecurityUtils.getLoginUser();
        Set<String> roles = loginUser.getRoles();
        // 促销AP管理角色，可查看所有数据
        if (!roles.contains(UserRoles.PROMOTION_AP_MANAGER)) {
            // 查询当前人员部门、姓名
            String deptName = loginUser.getSysUser().getDept().getDeptName();
            String nickname = loginUser.getNickName();
            salesApRequest.setDeptName(deptName)
                    .setNickName(nickname);
        }
    }
}
