package com.sfa.operation.controller.sales.core;

import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.qc.IQinceMarketEmployeeService;
import com.sfa.operation.service.sales.IApPromotionCoreService;
import com.sfa.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-09-17 15
 * @describe : 档期计划
 */
@RestController
@RequestMapping("/sales/ap_promotion/core")
public class ApPromotionCoreController {
    @Autowired
    private IApPromotionCoreService apPromotionCoreService;
    @Autowired
    private IQinceMarketEmployeeService qinceMarketEmployeeService;
    @PutMapping("/{id}")
    public void putDetail(@PathVariable("id") Long sapId, @RequestBody SalesApRequest request) {
        checkPermission();
        request.setSapId(sapId);
        apPromotionCoreService.updateDetail(request);
    }

    private void checkPermission(){
        // 是区域销售部的人员，查看人客关系
        LoginUser loginUser = SecurityUtils.getLoginUser();
        String empNo = loginUser.getUsername();
        List<String> dealerCodes = qinceMarketEmployeeService.checkPermission(empNo);
        if (dealerCodes.isEmpty()){
            throw new CheckedException(ECode.QC_MARKET_EMP_ERROR);
        }
    }
}
