package com.sfa.operation.util;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @author : liqiulin
 * @date : 2025-10-31 19
 * @describe :
 */
@Slf4j
@Component
public class T100Util {

    @Value("${t100.url}")
    private String url;

    @Value("${t100.ent_id}")
    private String entId;

    /**
     * 创建产品质检报告
     */
    public void createProQuality(JSONObject deptJson){
        deptJson.put("host",getHost());
        JSONObject datakey = new JSONObject();
        datakey.put("CompanyId","BJHQ");
        datakey.put("EntId",entId);
        deptJson.put("datakey",datakey);
        JSONObject service = new JSONObject();
        service.put("name","ins_cimi001");
        deptJson.put("service",service);
        log.info("T100-A-质检报告传参：{}",deptJson);
        String body = HttpUtil.createPost(url).body(deptJson.toString()).execute().body();
        String msg = body.replaceAll("\n", "");
        log.info("T100-A-质检报告结果：{}",msg);
    }

    /**
     * 修改产品质检报告
     */
    public void updateProQuality(JSONObject deptJson){
        deptJson.put("host",getHost());
        JSONObject datakey = new JSONObject();
        datakey.put("CompanyId","BJHQ");
        datakey.put("EntId",entId);
        deptJson.put("datakey",datakey);
        JSONObject service = new JSONObject();
        service.put("name","upd_cimi001");
        deptJson.put("service",service);
        log.info("T100-PUT-质检报告传参：{}",deptJson);
        String body = HttpUtil.createPost(url).body(deptJson.toString()).execute().body();
        String msg = body.replaceAll("\n", "");
        log.info("T100-PUT-质检报告结果：{}",msg);
    }
    private JSONObject getHost(){
        JSONObject host = new JSONObject();
        host.put("acct","tiptop");
        host.put("ip",null);
        host.put("lang","zh_CN");
        host.put("prod","CRM");
        host.put("timestamp", DateUtil.format(new Date(), DatePattern.NORM_DATETIME_MS_PATTERN));
        return host;
    }


}
