package com.sfa.operation.controller.sales.query;

import com.sfa.common.core.constant.RoleConstants;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.security.annotation.Logical;
import com.sfa.common.security.annotation.RequiresRoles;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.config.ConstantValue;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.qc.IQinceMarketEmployeeService;
import com.sfa.operation.service.sales.IApDisplayQueryService;
import com.sfa.system.api.domain.SysRole;
import com.sfa.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

/**
 * @author : liqiulin
 * @date : 2025-12-01 15
 * @describe :
 */
@RestController
@RequestMapping("/sales/ap_report/query")
public class APReportQueryController {
    @Autowired
    private IApDisplayQueryService apDisplayQueryService;
    @Autowired
    private IQinceMarketEmployeeService qinceMarketEmployeeService;
    @Autowired
    private ConstantValue constantValue;

    /**
     * 店内执行-城市经理
     */
    @GetMapping("/store_cm")
    public Object queryStoreAPReport(SalesApRequest request) {
        checkPermission(request);
        return apDisplayQueryService.queryStoreAPReport(request);
    }

    /**
     * 店内执行-大区/战区
     */
    @GetMapping("/dept_cm")
    @RequiresRoles(value = {RoleConstants.OPERATION_CENTER_AP_MANAGER, RoleConstants.OPERATIONZQ_AP_MANAGER, RoleConstants.OPERATIONDQ_AP_MANAGER, RoleConstants.DISTRICT_AP_MANAGER}, logical = Logical.OR)
    public Object queryDeptAPReport(SalesApRequest request) {
        checkPermissionDept(request);
        return apDisplayQueryService.queryDeptAPReport(request);
    }

    private void checkPermission(SalesApRequest salesApRequest) {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        String ancestors = loginUser.getSysUser().getDept().getAncestors();
        List<SysRole> roles = loginUser.getSysUser().getRoles();

        // 不是区域销售部的人员，可以查看所有
        if (!ancestors.contains(constantValue.deptYX) && roles.stream().filter(role -> RoleConstants.OPERATION_CENTER_AP_MANAGER.equals(role.getRoleKey())).findFirst().isPresent()) {
            return;
        }

        // 是区域销售部的人员：1、销售查看人客关系；2、大区TM查看当前部门下所有数据
        // 判断是否是大区TM
        String empNo = loginUser.getUsername();
        Optional<SysRole> first = roles.stream().filter(role -> RoleConstants.DISTRICT_AP_MANAGER.equals(role.getRoleKey())).findFirst();
        if (first.isPresent()) {
            String deptName = loginUser.getSysUser().getDept().getDeptName();
            salesApRequest.setDeptNames("000889".equals(empNo) ? Arrays.asList(deptName,"北京特区") : Arrays.asList(deptName));
            return;
        }
        // 不是大区TM，判断是否是销售人员(人客关系)
        List<String> dealerCodes = qinceMarketEmployeeService.checkPermission(empNo);
        if (dealerCodes.isEmpty()) {
            throw new CheckedException(ECode.QC_MARKET_EMP_ERROR);
        }
//        salesApRequest.setNickName(loginUser.getNickName());
        salesApRequest.setDealerCodes(dealerCodes);
    }

    private void checkPermissionDept(SalesApRequest salesApRequest) {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        String ancestors = loginUser.getSysUser().getDept().getAncestors();
        List<SysRole> roles = loginUser.getSysUser().getRoles();

        // 不是区域销售部的人员，可以查看所有
        if (!ancestors.contains(constantValue.deptYX) && roles.stream().filter(role -> RoleConstants.OPERATION_CENTER_AP_MANAGER.equals(role.getRoleKey())).findFirst().isPresent()) {
            return;
        }

        // 是区域销售部的人员按部门查询
        String empNo = loginUser.getUsername();
        String deptName = loginUser.getSysUser().getDept().getDeptName();
        salesApRequest.setDeptNames("000889".equals(empNo) ? Arrays.asList(deptName, "北京特区") : Arrays.asList(deptName));
    }
}
