package com.sfa.operation.service.sales.impl;

import cn.hutool.core.date.DatePattern;
import com.sfa.operation.domain.sales.dao.ISalesApPromotionDao;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.pojo.sales.response.SalesApPromotionDto;
import com.sfa.operation.service.sales.IApPromotionCoreService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.Date;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-09-17 15
 * @describe :
 */
@Service
public class ApPromotionCoreServiceImpl implements IApPromotionCoreService {
    @Autowired
    private ISalesApPromotionDao salesApPromotionDao;

    @Override
    public void updateDetail(SalesApRequest request) {
        // 修改DB 日期值为null
        try {
            SalesApPromotionDto dto = new SalesApPromotionDto();
            SalesApRequest.Promotion promotion = request.getPromotion();
            BeanUtils.copyProperties(promotion, dto);
            dto.setSapId(request.getSapId());
            Date parse = DatePattern.NORM_DATE_FORMAT.parse("2000-01-01");

            if (Objects.isNull(promotion.getActualPromotionStartDate())) {
                dto.setIsActualPromotionStartDate(true);
            } else if (promotion.getActualPromotionStartDate().compareTo(parse) == 0) {
                dto.setIsActualPromotionStartDate(false);
            }else {
                dto.setIsActualPromotionStartDate(true);
            }
            if (Objects.isNull(promotion.getActualPromotionEndDate())) {
                // DB 日期值无需修改
                dto.setIsActualPromotionEndDate(true);
            } else if (promotion.getActualPromotionEndDate().compareTo(parse) == 0) {
                // DB 日期值无需修改
                dto.setIsActualPromotionEndDate(false);
            }else {
                dto.setIsActualPromotionEndDate(true);
            }
            salesApPromotionDao.updateById(dto);
        } catch (ParseException e) {
            e.printStackTrace();
        }
    }
}
