package com.sfa.operation.strategy.impl.exports;


import com.sfa.operation.config.ExportColumnConfig;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.sales.IApDisplayQueryService;
import com.sfa.operation.strategy.IExportApExcelStrategy;
import com.sfa.operation.util.excel.ExcelStyleUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @Author: DouXinYu
 * @Date: 2025-12-08 17:24
 * @Description: 常规陈列策略接口实现类
 */
@Component("normalDisplayExportStrategy")
public class NormalDisplayExportStrategyImpl implements IExportApExcelStrategy {
    private static final String EXPORT_SHEET_NAME = "常规陈列";
    private static final String EXPORT_FILE_NAME_PREFIX = "常规陈列";

    @Autowired
    private IApDisplayQueryService apDisplayQueryService;

    /**
     * 获取导出列配置
     * @return 列配置
     */
    @Override
    public List<ExportColumnConfig> getExportColumnConfig() {
        List<ExportColumnConfig> column = new ArrayList<>();
        //处理填报列的规则限制
        //主货架形式-实际
        ExportColumnConfig actualMainShelfType = new ExportColumnConfig("actualMainShelfType", "主货架形式（实际）", "", ExcelStyleUtils.ExcelStyle.LIGHT_BLUE_BG);
        actualMainShelfType.setValidationValidOptions(Arrays.asList("3纵", "4纵", "5纵", "6纵", "7纵", "8纵及以上"));
        actualMainShelfType.setValidationErrorTitle("输入错误");
        actualMainShelfType.setValidationErrorMsg("主货架形式必须输入“3纵、4纵、5纵、6纵、7纵、8纵及以上”之一！");
        actualMainShelfType.setConditionalStyling(true);

        //主货架数量-实际
        ExportColumnConfig actualMainShelfQty = new ExportColumnConfig("actualMainShelfQty", "主货架数量（实际）", "", ExcelStyleUtils.ExcelStyle.LIGHT_BLUE_BG);
        actualMainShelfQty.setNumberValidation(true);
        actualMainShelfQty.setValidationNumberMin(0.0);
        actualMainShelfQty.setValidationNumberMax(999999999999999999.999999999999999999);
        actualMainShelfQty.setValidationErrorTitle("输入错误");
        actualMainShelfQty.setValidationErrorMsg("主货架数量必须输入大于等于0的数字！");
        actualMainShelfQty.setConditionalStyling(true);
        //端架数量-实际
        ExportColumnConfig actualEndCapQty = new ExportColumnConfig("actualEndCapQty", "端架数量（实际）", "", ExcelStyleUtils.ExcelStyle.LIGHT_BLUE_BG);
        actualEndCapQty.setNumberValidation(true);
        actualEndCapQty.setValidationNumberMin(0.0);
        actualEndCapQty.setValidationNumberMax(999999999999999999.999999999999999999);
        actualEndCapQty.setValidationErrorTitle("输入错误");
        actualEndCapQty.setValidationErrorMsg("端架数量必须输入大于等于0的数字！");
        actualEndCapQty.setConditionalStyling(true);

        //地堆面积-实际
        ExportColumnConfig actualFloorStackArea = new ExportColumnConfig("actualFloorStackArea", "地堆平米数（实际）", "", ExcelStyleUtils.ExcelStyle.LIGHT_GREY_BG);
        actualFloorStackArea.setValidationValidOptions(Arrays.asList("0","0.5","0.8","1","2","3","4","5","6","8"));
        actualFloorStackArea.setValidationErrorTitle("输入错误");
        actualFloorStackArea.setValidationErrorMsg("地堆面积必须输入0、0.5、0.8、1、2、3、4、5、6、8之一！");
        actualFloorStackArea.setConditionalStyling(true);

        //地堆数量-实际
        ExportColumnConfig actualFloorStackQty = new ExportColumnConfig("actualFloorStackQty", "地堆数量（实际）", "", ExcelStyleUtils.ExcelStyle.LIGHT_GREY_BG);
        actualFloorStackQty.setValidationValidOptions(Arrays.asList("0","1","2","3","4","5"));
        actualFloorStackQty.setValidationErrorTitle("输入错误");
        actualFloorStackQty.setValidationErrorMsg("地堆数量必须输入0、1、2、3、4、5之一！");
        actualFloorStackQty.setConditionalStyling(true);

        //多点陈列数量形式-实际
        ExportColumnConfig actualMultiDisplay = new ExportColumnConfig("actualMultiDisplay", "多点陈列数量形式（实际）", "", ExcelStyleUtils.ExcelStyle.LIGHT_BLUE_BG);
        actualMultiDisplay.setValidationValidOptions(Arrays.asList("执行与计划一致", "执行与计划不一致"));
        actualMultiDisplay.setValidationErrorTitle("输入错误");
        actualMultiDisplay.setValidationErrorMsg("多点陈列数量形式必须输入“执行与计划一致”或“执行与计划不一致”！");
        actualMultiDisplay.setConditionalStyling(true);

        //挂条数量形式-实际
        ExportColumnConfig actualHangingStripQuantityForm = new ExportColumnConfig("actualHangingStripQuantityForm", "挂条数量形式（实际）", "", ExcelStyleUtils.ExcelStyle.LIGHT_BLUE_BG);
        actualHangingStripQuantityForm.setValidationValidOptions(Arrays.asList("执行与计划一致", "执行与计划不一致"));
        actualHangingStripQuantityForm.setValidationErrorTitle("输入错误");
        actualHangingStripQuantityForm.setValidationErrorMsg("挂条数量形式必须输入“执行与计划一致”或“执行与计划不一致”！");
        actualHangingStripQuantityForm.setConditionalStyling(true);

        column.add(new ExportColumnConfig("sadId", "程序编号-请忽略", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("salesMonth", "计划月份", "YYYY-MM", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("regionName", "销售大区", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("districtName", "销售战区", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("dealerCode", "经销商代码", "@", ExcelStyleUtils.ExcelStyle.CHANGE_TEXT_STYLE));
        column.add(new ExportColumnConfig("dealerName", "经销商名称", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("storeCode",  "门店编码", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("storeName", "门店名称", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("lineName", "系统名称", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("plannedMainShelfType", "主货架形式（计划）", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(actualMainShelfType);
        column.add(new ExportColumnConfig("plannedMainShelfQty", "主货架数量（计划）", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(actualMainShelfQty);
        column.add(new ExportColumnConfig("plannedEndCapQty", "端架数量（计划）", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(actualEndCapQty);
        column.add(new ExportColumnConfig("plannedFloorStackArea", "地堆平米数（计划）", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(actualFloorStackArea);
        column.add(new ExportColumnConfig("plannedFloorStackQty", "地堆数量（计划）", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(actualFloorStackQty);
        column.add(new ExportColumnConfig("plannedMultiDisplay", "多点陈列数量形式（计划）", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(actualMultiDisplay);
        column.add(new ExportColumnConfig("plannedHangingStripQuantityForm", "挂条数量形式（计划）", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(actualHangingStripQuantityForm);
        column.add(new ExportColumnConfig("remark", "备注", "", ExcelStyleUtils.ExcelStyle.DEFAULT_STYLE));

        for (ExportColumnConfig exportColumnConfig : column) {
            System.out.println(exportColumnConfig.toString());
        }

        return column;
    }

    /**
     * 查询数据
     * @param salesApRequest 请求参数
     * @return  根据条换查询出的数据列表
     */
    @Override
    public List<?> queryData(SalesApRequest salesApRequest) {
        return apDisplayQueryService.queryDataListByCondition(salesApRequest);
    }

    @Override
    public String getExportSheetName() {
        return EXPORT_SHEET_NAME;
    }

    @Override
    public String getExportFileNamePrefix() {
        return EXPORT_FILE_NAME_PREFIX;
    }

}
