package com.sfa.operation.pojo.sales.request;

import cn.hutool.core.date.DatePattern;
import lombok.*;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-09-16 14
 * @describe :
 */
@Accessors(chain = true)
@Data
public class SalesApRequest {
    // ######################## 通用查询 ########################
    private String dealerCode;
    /**
     * 默认当月
     */
    private String salesMonth;
    /**
     * 经销商编码/名称（模糊）
     */
    private String dealerCN;
    private String cityManager;
    /**
     * 大区/战区（用来查询大区/战区两列）
     */
    private String deptName;
    private List<String> deptNames;
    /**
     * 门店编码/名称（模糊）
     */
    private String storeCN;
    /**
     * 登录人姓名
     */
    private String nickName;
    private List<String> dealerCodes;
    /**
     * 系统名称
     */
    private String lineNameLike;
    /**
     * 登录人工号
     */
    private String empNo;
    /**
     * 部门编码
     */
    private String deptCode;

    // ######################## 通用查询 ########################

    /**
     * 常规陈列表ID
     */
    private Long sadId;
    private Display display;

    /**
     * 档期计划表ID
     */
    private Long sapId;
    private Promotion promotion;

    /**
     * 档期陈列表ID
     */
    private Long sapdId;
    private PromotionDisplay promotionDisplay;

    /**
     * 零食陈列表ID
     */
    private Long sasdId;
    private SnackDisplay snackDisplay;

    /**
     * 三米两秒
     */
    private Long sadsId;
    private DisplayS displayS;

    /**
     * 六小金刚
     */
    private Long sadjId;
    private DisplayJ displayJ;

    @Data
    public static class Display{
        /**
         * 实际主货架-形式
         */
        private String actualMainShelfType;

        /**
         * 实际主货架-数量
         */
        private Integer actualMainShelfQty;

        /**
         * 实际主货架-是否执行
         */
        private String actualMainShelfExecuted;

        /**
         * 实际端架-数量
         */
        private Double actualEndCapQty;

        /**
         * 实际端架-是否执行
         */
        private String actualEndCapExecuted;


        /**
         * 实际地堆-平米数（㎡）
         */
        private Double actualFloorStackArea;

        /**
         * 实际地堆-数量
         */
        private Integer actualFloorStackQty;

        /**
         * 实际主题地堆-是否
         */
        private String actualThemedFloorStack;


        /**
         * 实际地堆是否执行
         */
        private String actualFloorStackExecuted;

        /**
         * 实际多点陈列-数量+形式
         */
        private String actualMultiDisplay;

        /**
         * 实际多点陈列-是否执行
         */
        private String actualMultiDisplayExecuted;


        /**
         * 常规陈列是否执行
         */
        private String regularDisplayExecuted;

        /**
         * 实际挂条-数量+形式
         */
        private String actualHangingStripQuantityForm;

        /**
         * 挂条-是否执行
         */
        private String hangingStripExecuted;

    }
    @Data
    public static class Promotion{
        /**
         * 档期执行-促销规格
         */
        private String actualPromotionSpec;
        /**
         * 实际执行规格
         */
        private String actualPromotionSpecRe;
        /**
         * 档期执行-促销口味
         */
        private String actualPromotionFlavor;
        /**
         * 实际执行口味
         */
        private String actualPromotionFlavorRe;
        /**
         * 档期规格是否执行
         */
        private String specExecutionStatus;

        /**
         * 促销口味是否执行
         */
        private String flavorExecutionStatus;

        /**
         * 实际-档期开始时间
         */
        private Date actualPromotionStartDate;
        {
            try {
                actualPromotionStartDate = DatePattern.NORM_DATE_FORMAT.parse("2000-01-01");
            } catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        /**
         * 实际-档期结束时间
         */
        private Date actualPromotionEndDate;
        {
            try {
                actualPromotionEndDate = DatePattern.NORM_DATE_FORMAT.parse("2000-01-01");
            } catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }

        /**
         * 档期是否开展
         */
        private String promotionImplementationStatus;
        /**
         * 时间是否执行
         */
        private String timeExecutionStatus;
        /**
         * 实际促销机制
         */
        private String actualPromotionMechanism;
        /**
         * 促销机制是否执行
         */
        private String promotionMechanismExecutionStatus;
        /**
         * 档期备货量（袋）
         */
        private Integer promotionStockQuantity;
        /**
         * 实际促销售价（单包）
         */
        private BigDecimal actualPromotionPrice;
        /**
         * 促销价是否执行
         */
        private String promotionPriceExecutionStatus;
        /**
         * 实际执行价格(填报)
         */
        private String actualPromotionPriceRe;
        /**
         * 档期是否执行
         */
        private String promotionExecutionStatus;
        /**
         * 实际-海报形式
         */
        private String actualPosterFormat;
        /**
         * 海报是否执行
         */
        private String posterExecutionStatus;
    }
    @Data
    private static class SnackDisplay {

        /**
         * 实际-陈列形式
         */
        private String actualDisplay;
        /**
         * 陈列形式是否执行
         */
        private String displayExecuted;

        /**
         * 实际-端架数量（组）
         */
        private String actualEndCapQty;
        /**
         * 端架数量是否执行
         */
        private String endCapQtyExecuted;
        /**
         * 零食陈列是否执行
         */
        private String snackDisplayExecuted;
    }
    @Data
    private static class PromotionDisplay {

        /**
         * 实际端架-数量
         */
        private Double actualEndCapQty;

        /**
         * 实际端架-是否执行
         */
        private String actualEndCapExecuted;

        /**
         * 实际地堆-平米数（㎡）
         */
        private Double actualFloorStackArea;

        /**
         * 实际地堆-数量
         */
        private Integer actualFloorStackQty;

        /**
         * 实际地堆是否执行
         */
        private String actualFloorStackExecuted;

        /**
         * 实际其他陈列-数量+形式
         */
        private String actualOtherDisplay;

        /**
         * 实际其他陈列-是否执行
         */
        private String actualOtherDisplayExecuted;

        /**
         * 档期陈列是否执行
         */
        private String promotionDisplayExecuted;
    }
    @Data
    private static class DisplayS{
        /**
         * 实际-60g挂条陈列数量
         */
        private String actualDisplayQty60;
        /**
         * 60g挂条陈列-是否执行
         */
        private String displayQtyExecuted60;
    }
    @Data
    private static class DisplayJ {
        /**
         * 实际执行-六小金刚批发挂网
         */
        private String actualGw6;
        /**
         * 六小金刚批发挂网-是否执行（Y=是，N=否）
         */
        private String gwExecuted6;
    }
}


