package com.sfa.operation.service.sales.impl;

import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.domain.sales.dao.*;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.pojo.sales.response.*;
import com.sfa.operation.service.sales.IApDisplayCoreService;
import org.omg.CORBA.PRIVATE_MEMBER;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2025-09-16 16
 * @describe :
 */
@Service
public class ApDisplayCoreServiceImpl implements IApDisplayCoreService {
    @Autowired
    private ISalesApDisplayDao salesApDisplayDao;
    @Autowired
    private ISalesApSnacksDisplayDao salesApSnacksDisplayDao;
    @Autowired
    private ISalesApPromotionDisplayDao salesApPromotionDisplayDao;
    @Autowired
    private ISalesApDisplaySDao salesApDisplaySDao;
    @Autowired
    private ISalesApDisplayJDao salesApDisplayJDao;
    @Override
    public void updateDetail(SalesApRequest request) {
        SalesApDisplayDto salesApDisplayDto = new SalesApDisplayDto();
        BeanUtils.copyProperties(request.getDisplay(), salesApDisplayDto);
        salesApDisplayDto.setSadId(request.getSadId());
        salesApDisplayDto.setUpdateBy(SecurityUtils.getNickName());
        salesApDisplayDao.updateDetail(salesApDisplayDto);
    }

    @Override
    public void putSnackDisplayDetail(SalesApRequest request) {
        SalesApSnacksDisplayDto sdDto = new SalesApSnacksDisplayDto();
        BeanUtils.copyProperties(request.getSnackDisplay(), sdDto);
        sdDto.setSasdId(request.getSasdId());
        sdDto.setUpdateBy(SecurityUtils.getNickName());
        salesApSnacksDisplayDao.updateDetail(sdDto);
    }

    @Override
    public void putProDisplayDetail(SalesApRequest request) {
        SalesApPromotionDisplayDto pdDto = new SalesApPromotionDisplayDto();
        BeanUtils.copyProperties(request.getPromotionDisplay(), pdDto);
        pdDto.setSapdId(request.getSapdId());
        pdDto.setUpdateBy(SecurityUtils.getNickName());
        salesApPromotionDisplayDao.updateDetail(pdDto);
    }

    @Override
    public void putDisplaySDetail(SalesApRequest request) {
        SalesApDisplaySDto dsDto = new SalesApDisplaySDto();
        BeanUtils.copyProperties(request.getDisplayS(), dsDto);
        dsDto.setSadsId(request.getSadsId());
        dsDto.setUpdateBy(SecurityUtils.getNickName());
        salesApDisplaySDao.updateDetail(dsDto);
    }

    @Override
    public void putDisplayJDetail(SalesApRequest request) {
        SalesApDisplayJDto djDto = new SalesApDisplayJDto();
        BeanUtils.copyProperties(request.getDisplayJ(), djDto);
        djDto.setSadjId(request.getSadjId());
        djDto.setUpdateBy(SecurityUtils.getNickName());
        salesApDisplayJDao.updateDetail(djDto);
    }
}
