package com.sfa.operation.controller.query;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.sfa.common.core.utils.DateUtils;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.service.IKqMxQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-11-05 13
 * @describe :
 */
@RestController
@RequestMapping("/kqmx/query")
public class KqMxQueryController {
    @Autowired
    IKqMxQueryService kqMxQueryService;

    @GetMapping("/roll")
    public Map rollDateList(){
        Long userId = SecurityUtils.getUserId();
        Date dateStart = DateUtils.dateStart(DateUtil.offsetDay(new DateTime(), -7));
        Map dataMap = kqMxQueryService.rollDateList(dateStart, userId);
        HashMap<String,Object> rMap = new HashMap<>();
        rMap.put("data",dataMap);
        rMap.put("current",new DateTime());
        return rMap;
    }
}
