package com.sfa.operation.strategy.impl.exports;

import com.sfa.operation.config.ExportColumnConfig;
import com.sfa.operation.domain.sales.dao.ISalesApPromotionDao;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.sales.IApDisplayQueryService;
import com.sfa.operation.strategy.IExportApExcelStrategy;
import com.sfa.operation.util.excel.ExcelStyleUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @Author: DouXinYu
 * @Date: 2025-12-16 13:28
 * @Description: 档期陈列导出策略实现类
 */

@Component("promotionDisplayExportStrategy")
public class PromotionDisplayExportStrategyImpl implements IExportApExcelStrategy {

    private static final String FILE_NAME_PREFIX = "档期陈列";
    private static final String SHEET_NAME = "档期陈列";

    @Autowired
    private IApDisplayQueryService apDisplayQueryService;


    @Override
    public List<ExportColumnConfig> getExportColumnConfig() {
        
        List<ExportColumnConfig> column = new ArrayList<>();
        //特殊列处理
        //实际端架数量
        ExportColumnConfig actualEndCapQty = new ExportColumnConfig("actualEndCapQty", "端架数量(实际)", "", ExcelStyleUtils.ExcelStyle.LIGHT_BLUE_BG);
        actualEndCapQty. setValidationValidOptions(Arrays.asList("0","0.5","1","2"));
        actualEndCapQty.setValidationErrorTitle("输入错误");
        actualEndCapQty.setValidationErrorMsg("端架数量必须是“0、0.5、1、2”之一！");
        actualEndCapQty.setConditionalStyling(true);

        //实际地堆平米数
        ExportColumnConfig actualFloorStackArea = new ExportColumnConfig("actualFloorStackArea", "地堆平米数（实际）", "", ExcelStyleUtils.ExcelStyle.LIGHT_BLUE_BG);
        actualFloorStackArea.setValidationValidOptions(Arrays.asList("0","0.5","0.8","1","2","3","4","5"));
        actualFloorStackArea.setValidationErrorTitle("输入错误");
        actualFloorStackArea.setValidationErrorMsg("地堆平米数必须是“0、0.5、0.8、1、2、3、4、5”之一！");
        actualFloorStackArea.setConditionalStyling(true);

        //实际地堆数量
        ExportColumnConfig actualFloorStackQty = new ExportColumnConfig("actualFloorStackQty", "地堆数量（实际）", "", ExcelStyleUtils.ExcelStyle.LIGHT_BLUE_BG);
        actualFloorStackQty.setNumberValidation(true);
        actualFloorStackQty.setValidationNumberMin(0.0);
        actualFloorStackQty.setValidationNumberMax(99999999999999999.999999999999999999);
        actualFloorStackQty.setValidationErrorTitle("输入错误");
        actualFloorStackQty.setValidationErrorMsg("地堆数量必须是大于0的数字！");
        actualFloorStackQty.setConditionalStyling(true);

        //实际其他陈列数量+形式
        ExportColumnConfig actualOtherDisplay = new ExportColumnConfig("actualOtherDisplay", "其他陈列数量+形式(实际)", "", ExcelStyleUtils.ExcelStyle.LIGHT_BLUE_BG);
        actualOtherDisplay.setValidationValidOptions(Arrays.asList("执行与计划一致","执行与计划不一致"));
        actualOtherDisplay.setValidationErrorTitle("输入错误");
        actualOtherDisplay.setValidationPromptMsg("其他陈列数量+形式（实际）必须输入“执行与计划一致”或“执行与计划不一致”！");
        actualOtherDisplay.setConditionalStyling(true);

        column.add(new ExportColumnConfig("sapdId", "程序编号-请忽略", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("salesMonth", "计划月份", "YYYY-MM", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("regionName", "销售大区", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("districtName", "销售战区", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("dealerCode","经销商代码","@", ExcelStyleUtils.ExcelStyle.CHANGE_TEXT_STYLE));
        column.add(new ExportColumnConfig("dealerName", "经销商名称", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("lineName", "系统名称", "", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("storeCode","门店编码","", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("store_name","门店名称","", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(new ExportColumnConfig("plannedEndCapQty","端架数量（计划）","", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(actualEndCapQty);
        column.add(new ExportColumnConfig("plannedFloorStackArea","地堆平米数（计划）","", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(actualFloorStackArea);
        column.add(new ExportColumnConfig("plannedFloorStackQty","地堆数量（计划）","", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(actualFloorStackQty);
        column.add(new ExportColumnConfig("plannedOtherDisplay","其他陈列数量+形式（计划）","", ExcelStyleUtils.ExcelStyle.UNMODIFIABLE));
        column.add(actualOtherDisplay);
        column.add(new ExportColumnConfig("remark","备注","", ExcelStyleUtils.ExcelStyle.DEFAULT_STYLE));

        return column;
    }

    @Override
    public List<?> queryData(SalesApRequest salesApRequest) {
        return apDisplayQueryService.queryPromotionDisplayByCondition(salesApRequest);
    }

    @Override
    public String getExportSheetName() {
        return SHEET_NAME;
    }

    @Override
    public String getExportFileNamePrefix() {
        return FILE_NAME_PREFIX;
    }
}
