package com.sfa.operation.domain.sales.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.core.utils.DateUtils;
import com.sfa.common.core.utils.StringUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.operation.domain.sales.dao.ISalesApSnacksDisplayDao;
import com.sfa.operation.domain.sales.entity.SalesApSnacksDisplay;
import com.sfa.operation.domain.sales.mapper.SalesApSnacksDisplayMapper;
import com.sfa.operation.domain.sales.wq.SalesApWq;
import com.sfa.operation.pojo.sales.response.SalesApSnacksDisplayDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-09-26 13
 * @describe :
 */
@DS("bi")
@Service
public class SalesApSnacksDisplayDaoImpl implements ISalesApSnacksDisplayDao {
    @Autowired
    private SalesApSnacksDisplayMapper salesapsnackdsDisplayMapper;
    @Override
    public PageInfo page(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApSnacksDisplay> qw = buildWq(salesApWq);
        Page<SalesApSnacksDisplay> page = salesapsnackdsDisplayMapper.selectPage(TableSupport.pageI(), qw);
        return new PageInfo(page);
    }

    @Override
    public void updateDetail(SalesApSnacksDisplayDto sdDto) {
        SalesApSnacksDisplay salesApSnacksDisplay = salesapsnackdsDisplayMapper.selectById(sdDto.getSasdId());
        if (!DateUtils.isSameYearMonth(salesApSnacksDisplay.getSalesMonth(),new Date())){
            throw new CheckedException(ECode.SALES_AP_UPDATE_ERROR);
        }
        SalesApSnacksDisplay entity = new SalesApSnacksDisplay();
        BeanUtils.copyProperties(sdDto, entity);
        salesapsnackdsDisplayMapper.updateById(entity);
    }

    /**
     * 导出-根据条件查询
     * @param build 查询条件
     * @return 查询结果
     */
    @Override
    public List<SalesApSnacksDisplay> querySnackByCondition(SalesApWq build) {
        LambdaQueryWrapper<SalesApSnacksDisplay> wq = buildWq(build);
        return salesapsnackdsDisplayMapper.selectList(wq);
    }

    private LambdaQueryWrapper<SalesApSnacksDisplay> buildWq(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApSnacksDisplay> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(salesApWq.getSalesMonth())){
            qw.eq(SalesApSnacksDisplay::getSalesMonth, salesApWq.getSalesMonth());
        }
        if (StringUtils.isNotBlank(salesApWq.getRqStatus())){
            qw.eq(SalesApSnacksDisplay::getSnackDisplayExecuted, salesApWq.getRqStatus());
        }
        if (!CollectionUtils.isEmpty(salesApWq.getDealerCodes())) {
            qw.in(SalesApSnacksDisplay::getDealerCode, salesApWq.getDealerCodes());
        }
        if (!CollectionUtils.isEmpty(salesApWq.getDeptNames())){
            qw.and(
                    wrapper -> wrapper.in(SalesApSnacksDisplay::getRegionName, salesApWq.getDeptNames())
                            .or()
                            .in(SalesApSnacksDisplay::getDistrictName, salesApWq.getDeptNames())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getDeptName())) {
            qw.and(
                    wrapper -> wrapper.like(SalesApSnacksDisplay::getRegionName, salesApWq.getDeptName())
                            .or()
                            .like(SalesApSnacksDisplay::getDistrictName, salesApWq.getDeptName())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getNickName())){
            qw.and(
                    wrapper -> wrapper.eq(SalesApSnacksDisplay::getRegionManager, salesApWq.getNickName())
                            .or()
                            .eq(SalesApSnacksDisplay::getDistrictManager, salesApWq.getNickName())
                            .or()
                            .eq(SalesApSnacksDisplay::getCityManager, salesApWq.getNickName())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getDealerCN())){
            qw.and(
                    wrapper -> wrapper.like(SalesApSnacksDisplay::getDealerName, salesApWq.getDealerCN())
                            .or()
                            .like(SalesApSnacksDisplay::getDealerCode, salesApWq.getDealerCN())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getStoreCN())){
            qw.and(
                    wrapper -> wrapper.like(SalesApSnacksDisplay::getStoreName, salesApWq.getStoreCN())
                            .or()
                            .like(SalesApSnacksDisplay::getStoreCode, salesApWq.getStoreCN())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getLineNameLike())){
            qw.like(SalesApSnacksDisplay::getLineName, salesApWq.getLineNameLike());
        }
        return qw;
    }
}
