package com.sfa.operation.strategy;

import com.sfa.operation.config.ExportColumnConfig;
import com.sfa.operation.domain.sales.entity.SalesApDisplay;
import com.sfa.operation.pojo.sales.excel.SalesApDisplayImportExcelDto;


import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * @Author: DouXinYu
 * @Date: 2025-12-10 16:21
 * @Description: 店内执行填报 - 导入策略接口
 */

public interface IImportApExcelStrategy<T> {
    /**
     * 获取导入列配置（复用导出列配置）
     */
    List<ExportColumnConfig> getImportColumnConfig();

    /**
     * 解析Excel文件流为DTO列表
     */
    List<T> parseExcelToDtoList(InputStream inputStream, String flePathUrl,Map<String, List<T>> errorMap);

    /**
     * 预处理DTO数据（补充关联数据）
     */
    void preprocessData(List<T> dtoList);

    /**
     * 数据库批量操作（新增/更新）
     */
    int queryAndBatchOperate(List<T> dtoList);

    /**
     * 构建更新实体列表
     */
    List<?>buildUpdateEntityList(List<T> dtoList);

    /**
     * 查询数据库数据
     */
     List<?> queryData(List<T> dto);

    /**
     * 更新数据库数据
     */

    String updateDisplay(List<T> dtoList);

    List<T>  getTransactionJsonToObject(String json);
    /**
     * 导入核心执行方法
     */
    Map<String, Object> execute(String flePathUrl);

    /**
     * 获取导入目标DTO类
     * @return 目标DTO类
     */
    Class<?> getTargetDtoClass();

    /**
     * 获取导入Sheet名称（默认方法）
     */
    default String getImportSheetName() {
        return "";
    }


}
