package com.sfa.operation.controller.sales.core;

import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.qc.IQinceMarketEmployeeService;
import com.sfa.operation.service.sales.IApDisplayCoreService;
import com.sfa.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-09-16 15
 * @describe : 常规陈列、档期陈列、零食陈列
 */
@RestController
@RequestMapping("/sales/ap_display")
public class ApDisplayCoreController {
    @Autowired
    private IApDisplayCoreService apDisplayCoreService;
    @Autowired
    private IQinceMarketEmployeeService qinceMarketEmployeeService;
    /**
     * 常规陈列 根据id更新
     */
    @PutMapping("/core/{id}")
    public void putDetail(@PathVariable("id") Long sadId, @RequestBody SalesApRequest request){
        checkPermission();
        request.setSadId(sadId);
        apDisplayCoreService.updateDetail(request);
    }

    /**
     * 档期陈列 根据id更新
     */
    @PutMapping("/core_pro/{id}")
    public void putProDisplayDetail(@PathVariable("id") Long sapdId, @RequestBody SalesApRequest request){
        checkPermission();
        request.setSapdId(sapdId);
        apDisplayCoreService.putProDisplayDetail(request);
    }

    /**
     * 零食陈列 根据id更新
     */
    @PutMapping("/core_snack/{id}")
    public void putSnackDisplayDetail(@PathVariable("id") Long sasdId, @RequestBody SalesApRequest request){
        checkPermission();
        request.setSasdId(sasdId);
        apDisplayCoreService.putSnackDisplayDetail(request);
    }

    private void checkPermission(){
        // 是区域销售部的人员，查看人客关系
        LoginUser loginUser = SecurityUtils.getLoginUser();
        String empNo = loginUser.getUsername();
        List<String> dealerCodes = qinceMarketEmployeeService.checkPermission(empNo);
        if (dealerCodes.isEmpty()){
            throw new CheckedException(ECode.QC_MARKET_EMP_ERROR);
        }
    }

}
