package com.sfa.operation.controller.qc.query;

import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.service.qc.IQinceMarketEmployeeService;
import com.sfa.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-10-29 13
 * @describe :勤策 - 经销商人客关系
 */
@RestController
@RequestMapping("/qc/market/emp")
public class QcMarketEmpQuery {
    @Autowired
    private IQinceMarketEmployeeService qinceMarketEmployeeService;

    @GetMapping
    public boolean query() {
        // 是区域销售部的人员，查看人客关系
        LoginUser loginUser = SecurityUtils.getLoginUser();
        String empNo = loginUser.getUsername();
        List<String> dealerCodes = qinceMarketEmployeeService.checkPermission(empNo);
        return !dealerCodes.isEmpty();
    }
}

