package com.sfa.operation.pojo.sfa.request;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author : liqiulin
 * @date : 2024-11-04 16
 * @describe :
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class KqMxVo {
    @NotNull(message = "打卡经纬度获取不到")
    private BigDecimal[] kqLocal;
    @NotBlank(message = "打卡省份获取不到")
    private String kqProvinc;
    @NotBlank(message = "打卡城市获取不到")
    private String kqCity;
    @NotBlank(message = "打卡区域获取不到")
    private String kqCounty;
    @NotBlank(message = "详细位置获取不到")
    private String kqAddress;
    private String kqPicurl;

    /**
     * 1:上班;2:午班;3:下班;
     */
    @NotNull(message = "无法判断上下班类型，请刷新重试")
    @Max(value = 3,message = "无法判断上下班类型，请刷新重试(<=3)")
    @Min(value = 1,message = "无法判断上下班类型，请刷新重试(>=1)")
    private Integer kqType;

}
