package com.sfa.operation;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.PropertyKeyConst;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.sfa.common.security.annotation.EnableCustomConfig;
import com.sfa.common.security.annotation.EnableRyFeignClients;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;

import java.util.Properties;

@ComponentScan(basePackages = {"com.sfa.common.core.utils.sdk","com.sfa.operation"})
@EnableCustomConfig
@EnableRyFeignClients
@MapperScan("com.sfa.operation.domain.*.mapper")
@SpringBootApplication
public class WangxiaoluSfaModuleOperationApplication {

    public static void main(String[] args) {
        SpringApplication.run(WangxiaoluSfaModuleOperationApplication.class, args);

        final String proNacosIp = System.getenv("PRO_NACOS_IP");
        final String proNacosPort = System.getenv("PRO_NACOS_PORT");
        final String proNacosNameSpace = System.getenv("PRO_NACOS_NS");
        final String serviceIp = System.getenv("SERVICE_IP");
        final String servicePort = System.getenv("SERVICE_PORT");

//        todo qa\live没问题之后删除打印信息
        System.out.println("打印环境变量");
        System.out.println("proNacosIp:"+proNacosIp);
        System.out.println("proNacosPort:"+proNacosPort);
        System.out.println("proNacosNameSpace:"+proNacosNameSpace);
        System.out.println("serviceIp:"+serviceIp);
        System.out.println("servicePort:"+servicePort);

        try {
            // 创建Nacos客户端配置(需要注册的地址，命名空间ID)
            Properties properties = new Properties();
            properties.put(PropertyKeyConst.SERVER_ADDR, proNacosIp+":"+proNacosPort);
            properties.put(PropertyKeyConst.NAMESPACE, proNacosNameSpace);
            // 创建NamingService实例
            NamingService namingService = NacosFactory.createNamingService(properties);
            // 注册服务到以上配置的nacos中
            Instance instance1 = new Instance();
            instance1.setIp(serviceIp);
            instance1.setPort(Integer.parseInt(servicePort));
            namingService.registerInstance("wangxiaolu-sfa-operation","promotion", instance1);
        } catch (NacosException e) {
            e.printStackTrace();
        }
    }

}
