package com.sfa.operation.domain.risk.dao.impl;

import cn.hutool.core.lang.func.VoidFunc0;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.WXLSQLException;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.operation.domain.risk.dao.IRiskStoreTaskDao;
import com.sfa.operation.domain.risk.entity.RiskStoreTask;
import com.sfa.operation.domain.risk.entity.RiskStoreTaskDetail;
import com.sfa.operation.domain.risk.mapper.RiskStoreTaskDetailMapper;
import com.sfa.operation.domain.risk.mapper.RiskStoreTaskMapper;
import com.sfa.operation.domain.risk.wq.RiskStoreTaskWq;
import com.sfa.operation.pojo.risk.response.RiskStoreTaskDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2025-08-27 20
 * @describe :
 */
@DS("bi")
@Repository
public class RiskStoreTaskDaoImpl implements IRiskStoreTaskDao {
    @Autowired
    private RiskStoreTaskMapper riskStoreTaskMapper;
    @Autowired
    private RiskStoreTaskDetailMapper riskStoreTaskDetailMapper;
    @Override
    public RiskStoreTaskDto insert(RiskStoreTaskDto taskDto) {
        try {
            RiskStoreTask taskDo = BeanUtils.transitionDto(taskDto, RiskStoreTask.class);
            taskDo.setCreateDate(new Date());
            riskStoreTaskMapper.insert(taskDo);
            taskDto.setRstId(taskDo.getRstId());
            return taskDto;
        }catch (Exception e){
            String eMsg = e.getCause().getMessage();
            if (eMsg.contains("for key 'user_task'")) {
                throw new WXLSQLException(ECode.DB_TABLE_UNIQUE_EXIST, "今日此售点任务");
            }
            throw new WXLSQLException(ECode.DB_TABLE_UPDATE_ERROR);
        }
    }

    @Override
    public PageInfo page(RiskStoreTaskWq wq) {
        LambdaQueryWrapper<RiskStoreTask> rqw = buildWq(wq);
        Page<RiskStoreTask> pageDos = riskStoreTaskMapper.selectPage(TableSupport.pageI(), rqw);
        return new PageInfo(pageDos);
    }

    @Override
    public RiskStoreTaskDto updateInspectStore(RiskStoreTaskDto taskDto) {
        RiskStoreTask taskDo = BeanUtils.transitionDto(taskDto, RiskStoreTask.class);
        riskStoreTaskMapper.updateById(taskDo);
        RiskStoreTask riskStoreTask = riskStoreTaskMapper.selectById(taskDo.getRstId());
        RiskStoreTaskDto tDto = BeanUtils.transitionDto(riskStoreTask, RiskStoreTaskDto.class);
        tDto.tranArr();
        return tDto;
    }

    @Override
    public RiskStoreTaskDto selectOne(RiskStoreTaskWq wq) {
        LambdaQueryWrapper<RiskStoreTask> rqw = buildWq(wq);
        RiskStoreTask riskStoreTask = riskStoreTaskMapper.selectOne(rqw);
        if (Objects.isNull(riskStoreTask)){
            return null;
        }
        RiskStoreTaskDto tDto = BeanUtils.transitionDto(riskStoreTask, RiskStoreTaskDto.class);
        tDto.tranArr();
        List<RiskStoreTaskDetail> riskStoreTaskDetails = riskStoreTaskDetailMapper.selectList(new LambdaQueryWrapper<RiskStoreTaskDetail>().eq(RiskStoreTaskDetail::getRstId, riskStoreTask.getRstId()));
        if (CollectionUtils.isEmpty(riskStoreTaskDetails)){
            return tDto;
        }
        // 返回任务明细
        List<RiskStoreTaskDto.RiskStoreTaskDetailDto> taskDetailDtos = BeanUtils.transitionDtos(riskStoreTaskDetails, RiskStoreTaskDto.RiskStoreTaskDetailDto.class);
        taskDetailDtos.forEach(detailDto -> rDetail(detailDto));
        Map<String, List<RiskStoreTaskDto.RiskStoreTaskDetailDto>> detailMap = taskDetailDtos.stream().collect(Collectors.groupingBy(RiskStoreTaskDto.RiskStoreTaskDetailDto::getDetailName));
        tDto.setDetailMap(detailMap);


        return tDto;
    }

    @Override
    public RiskStoreTaskDto.RiskStoreTaskDetailDto saveStoreDetail(Long rstId, String detailName) {
        RiskStoreTaskDetail taskDetailDo = new RiskStoreTaskDetail();
        taskDetailDo.setRstId(rstId);
        taskDetailDo.setDetailName(detailName);
        riskStoreTaskDetailMapper.insert(taskDetailDo);
        return BeanUtils.transitionDto(taskDetailDo, RiskStoreTaskDto.RiskStoreTaskDetailDto.class);
    }

    @Override
    public RiskStoreTaskDto.RiskStoreTaskDetailDto updateStoreDetail(RiskStoreTaskDto.RiskStoreTaskDetailDto riskStoreTaskDetailDto) {
        RiskStoreTaskDetail detailDo = BeanUtils.transitionDto(riskStoreTaskDetailDto, RiskStoreTaskDetail.class);
        riskStoreTaskDetailMapper.updateById(detailDo);
        RiskStoreTaskDetail riskStoreTaskDetail = riskStoreTaskDetailMapper.selectById(detailDo.getRstdId());
        RiskStoreTaskDto.RiskStoreTaskDetailDto tDto = BeanUtils.transitionDto(riskStoreTaskDetail, RiskStoreTaskDto.RiskStoreTaskDetailDto.class);
        rDetail(tDto);
        return tDto;
    }

    @Override
    public void deleteStoreDetail(Long rstdId) {
        riskStoreTaskDetailMapper.deleteById(rstdId);
    }

    private LambdaQueryWrapper<RiskStoreTask> buildWq(RiskStoreTaskWq wq) {
        LambdaQueryWrapper<RiskStoreTask> wqWrapper = new LambdaQueryWrapper<>();
        if (Objects.nonNull(wq.getRstId())){
            wqWrapper.eq(RiskStoreTask::getRstId, wq.getRstId());
        }
        if (StringUtils.isNotBlank(wq.getStoreName())){
            wqWrapper.like(RiskStoreTask::getStoreName, wq.getStoreName());
        }
        if (StringUtils.isNotBlank(wq.getStoreCode())){
            wqWrapper.like(RiskStoreTask::getStoreCode, wq.getStoreCode());
        }
        if (StringUtils.isNotBlank(wq.getOperEmpNo())){
            wqWrapper.eq(RiskStoreTask::getCreateEmpNo, wq.getOperEmpNo());
        }
        if (Objects.nonNull(wq.getOperDate())){
            wqWrapper.eq(RiskStoreTask::getCreateDate, wq.getOperDate());
        }
        wqWrapper.orderByDesc(RiskStoreTask::getCreateTime);
        return wqWrapper;
    }
    private void rDetail(RiskStoreTaskDto.RiskStoreTaskDetailDto tDto) {
        tDto.setPhotoArr(StringUtils.isBlank(tDto.getPhotos()) ? null : tDto.getPhotos().split(","));
        tDto.setRiskRArr(StringUtils.isBlank(tDto.getRiskR()) ? null : tDto.getRiskR().split(","));
        tDto.setKwYmHp210Map(StringUtils.isBlank(tDto.getKwYmHp210()) ? null : JSONObject.parseObject(tDto.getKwYmHp210(), Map.class));
        tDto.setKwYmHp105Map(StringUtils.isBlank(tDto.getKwYmHp105()) ? null : JSONObject.parseObject(tDto.getKwYmHp105(), Map.class));
        tDto.setKwYmHp68Map(StringUtils.isBlank(tDto.getKwYmHp68()) ? null : JSONObject.parseObject(tDto.getKwYmHp68(), Map.class));
        tDto.setKwYmJrdb120Map(StringUtils.isBlank(tDto.getKwYmJrdb120()) ? null : JSONObject.parseObject(tDto.getKwYmJrdb120(), Map.class));
        tDto.setKwYmNrdb120Map(StringUtils.isBlank(tDto.getKwYmNrdb120()) ? null : JSONObject.parseObject(tDto.getKwYmNrdb120(), Map.class));
        tDto.setKwYmQg72Map(StringUtils.isBlank(tDto.getKwYmQg72()) ? null : JSONObject.parseObject(tDto.getKwYmQg72(), Map.class));
        tDto.setKwYmQg138Map(StringUtils.isBlank(tDto.getKwYmQg138()) ? null : JSONObject.parseObject(tDto.getKwYmQg138(), Map.class));
        tDto.setKwYmHpjt80Map(StringUtils.isBlank(tDto.getKwYmHpjt80()) ? null : JSONObject.parseObject(tDto.getKwYmHpjt80(), Map.class));
        tDto.setKwYmLlMap(StringUtils.isBlank(tDto.getKwYmLl()) ? null : JSONObject.parseObject(tDto.getKwYmLl(), Map.class));
        tDto.setKwYmHpDzMap(StringUtils.isBlank(tDto.getKwYmHpDz()) ? null : JSONObject.parseObject(tDto.getKwYmHpDz(), Map.class));
        tDto.setKwYmHpScMap(StringUtils.isBlank(tDto.getKwYmHpSc()) ? null : JSONObject.parseObject(tDto.getKwYmHpSc(), Map.class));
    }




}
