package com.sfa.operation.controller.risk.core;

import com.alibaba.fastjson2.JSONObject;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.pojo.risk.request.RiskStoreTaskVo;
import com.sfa.operation.pojo.risk.response.RiskInspectStoreDto;
import com.sfa.operation.pojo.risk.response.RiskStoreTaskDto;
import com.sfa.operation.service.risk.IRiskStoreCoreService;
import com.sfa.operation.service.risk.IRiskStoreTaskCoreService;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-08-27 20
 * @describe : 风控中心-售点稽查
 */
@RestController
@RequestMapping("/risk/core")
public class RiskStoreTaskCoreController {
    @Autowired
    private IRiskStoreTaskCoreService riskstoreTaskCoreService;
    @Autowired
    private IRiskStoreCoreService riskstoreCoreService;
    @PostMapping("/i_store")
    public RiskStoreTaskDto inspectStore(@RequestBody RiskStoreTaskVo riskStoreTaskVo) {
        riskStoreTaskVo.setOperName(SecurityUtils.getNickName());
        riskStoreTaskVo.setOperEmpNo(SecurityUtils.getUsername());
        // 保存来源勤策的门店
        if (Objects.nonNull(riskStoreTaskVo.getStoreCode())){
            RiskInspectStoreDto storeDto = riskstoreCoreService.saveInspectStore(riskStoreTaskVo);
            riskStoreTaskVo.setStoreName(StringUtils.isNotBlank(storeDto.getRStoreName()) ? storeDto.getRStoreName() : riskStoreTaskVo.getStoreName());
        }

        RiskStoreTaskDto dto = null;
        // 是否新建
        if (Objects.isNull(riskStoreTaskVo.getRstId())){
            dto = riskstoreTaskCoreService.inspectStore(riskStoreTaskVo);
        }else {
            riskStoreTaskVo.setStoreName(StringUtils.isNotBlank(riskStoreTaskVo.getRStoreName()) ? riskStoreTaskVo.getRStoreName() : riskStoreTaskVo.getStoreName());
            dto = riskstoreTaskCoreService.updateInspectStore(riskStoreTaskVo);
        }
        return dto;
    }

    @PostMapping("/i_store_detail")
    public RiskStoreTaskDto.RiskStoreTaskDetailDto inspectStoreDetail(@RequestBody RiskStoreTaskVo riskStoreTaskVo) {
        RiskStoreTaskVo.TaskDetailVo taskDetailVo = riskStoreTaskVo.getTaskDetail();
        if (Objects.isNull(taskDetailVo.getRstdId())){
            return riskstoreTaskCoreService.saveStoreDetail(taskDetailVo);
        }
        RiskStoreTaskDto.RiskStoreTaskDetailDto riskStoreTaskDetailDto = new RiskStoreTaskDto.RiskStoreTaskDetailDto();
        BeanUtils.copyProperties(taskDetailVo,riskStoreTaskDetailDto);
        riskStoreTaskDetailDto.setPhotos(ArrayUtils.isEmpty(taskDetailVo.getPhotoArr()) ? null : StringUtils.join(taskDetailVo.getPhotoArr(),","));
        riskStoreTaskDetailDto.setRiskR(ArrayUtils.isEmpty(taskDetailVo.getRiskRArr()) ? null : StringUtils.join(taskDetailVo.getRiskRArr(),","));
        riskStoreTaskDetailDto.setKwYmHp210(CollectionUtils.isEmpty(taskDetailVo.getKwYmHp210Map()) ? null: JSONObject.toJSONString(taskDetailVo.getKwYmHp210Map()));
        riskStoreTaskDetailDto.setKwYmHp105(CollectionUtils.isEmpty(taskDetailVo.getKwYmHp105Map()) ? null: JSONObject.toJSONString(taskDetailVo.getKwYmHp105Map()));
        riskStoreTaskDetailDto.setKwYmHp68(CollectionUtils.isEmpty(taskDetailVo.getKwYmHp68Map()) ? null: JSONObject.toJSONString(taskDetailVo.getKwYmHp68Map()));
        riskStoreTaskDetailDto.setKwYmJrdb120(CollectionUtils.isEmpty(taskDetailVo.getKwYmJrdb120Map()) ? null: JSONObject.toJSONString(taskDetailVo.getKwYmJrdb120Map()));
        riskStoreTaskDetailDto.setKwYmNrdb120(CollectionUtils.isEmpty(taskDetailVo.getKwYmNrdb120Map()) ? null: JSONObject.toJSONString(taskDetailVo.getKwYmNrdb120Map()));
        riskStoreTaskDetailDto.setKwYmQg72(CollectionUtils.isEmpty(taskDetailVo.getKwYmQg72Map()) ? null: JSONObject.toJSONString(taskDetailVo.getKwYmQg72Map()));
        riskStoreTaskDetailDto.setKwYmQg138(CollectionUtils.isEmpty(taskDetailVo.getKwYmQg138Map()) ? null: JSONObject.toJSONString(taskDetailVo.getKwYmQg138Map()));
        riskStoreTaskDetailDto.setKwYmHpjt80(CollectionUtils.isEmpty(taskDetailVo.getKwYmHpjt80Map()) ? null: JSONObject.toJSONString(taskDetailVo.getKwYmHpjt80Map()));
        riskStoreTaskDetailDto.setKwYmLl(CollectionUtils.isEmpty(taskDetailVo.getKwYmLlMap()) ? null: JSONObject.toJSONString(taskDetailVo.getKwYmLlMap()));
        riskStoreTaskDetailDto.setKwYmHpDz(CollectionUtils.isEmpty(taskDetailVo.getKwYmHpDzMap()) ? null: JSONObject.toJSONString(taskDetailVo.getKwYmHpDzMap()));
        riskStoreTaskDetailDto.setKwYmHpSc(CollectionUtils.isEmpty(taskDetailVo.getKwYmHpScMap()) ? null: JSONObject.toJSONString(taskDetailVo.getKwYmHpScMap()));
        return riskstoreTaskCoreService.updateStoreDetail(riskStoreTaskDetailDto);
    }

    @DeleteMapping("/d_store_detail")
    public void deleteStoreDetail(Long rstdId) {
        riskstoreTaskCoreService.deleteStoreDetail(rstdId);
    }
}
