package com.sfa.operation.controller.risk.query;

import com.sfa.common.core.utils.DateUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.pojo.risk.request.RiskStoreTaskVo;
import com.sfa.operation.pojo.risk.response.RiskStoreTaskDto;
import com.sfa.operation.service.risk.IRiskStoreTaskQueryService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

/**
 * @author : liqiulin
 * @date : 2025-08-28 11
 * @describe : 风控中心-售点稽查 查询
 */
@RestController
@RequestMapping("/risk/query")
public class RiskStoreTaskQueryController {
    @Autowired
    private IRiskStoreTaskQueryService iRiskStoreTaskQueryService;
    @GetMapping("/i_store/page")
    public PageInfo page(@ModelAttribute RiskStoreTaskVo riskStoreTaskVo){
        riskStoreTaskVo.setOperEmpNo(SecurityUtils.getUsername());
        return iRiskStoreTaskQueryService.page(riskStoreTaskVo);
    }
    @GetMapping("/i_store")
    public RiskStoreTaskDto detail(RiskStoreTaskVo riskStoreTaskVo){
        if (StringUtils.isNotBlank(riskStoreTaskVo.getStoreCode())){
            riskStoreTaskVo.setOperEmpNo(SecurityUtils.getUsername());
            riskStoreTaskVo.setOperDate(DateUtils.dateStart(new Date()));
            riskStoreTaskVo.setStoreName(null);
        }
        return iRiskStoreTaskQueryService.getDetail(riskStoreTaskVo);
    }
}
