package com.sfa.operation.domain.sales.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sfa.common.core.utils.StringUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.operation.domain.sales.dao.ISalesApSnacksDisplayDao;
import com.sfa.operation.domain.sales.entity.SalesApSnacksDisplay;
import com.sfa.operation.domain.sales.mapper.SalesApSnacksDisplayMapper;
import com.sfa.operation.domain.sales.wq.SalesApWq;
import com.sfa.operation.pojo.sales.response.SalesApSnacksDisplayDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-09-26 13
 * @describe :
 */
@DS("bi")
@Service
public class SalesApSnacksDisplayDaoImpl implements ISalesApSnacksDisplayDao {
    @Autowired
    private SalesApSnacksDisplayMapper salesapsnackdsDisplayMapper;
    @Override
    public PageInfo page(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApSnacksDisplay> qw = buildWq(salesApWq);
        Page<SalesApSnacksDisplay> page = salesapsnackdsDisplayMapper.selectPage(TableSupport.pageI(), qw);
        return new PageInfo(page);
    }

    @Override
    public void updateDetail(SalesApSnacksDisplayDto sdDto) {
        SalesApSnacksDisplay salesApSnacksDisplay = new SalesApSnacksDisplay();
        BeanUtils.copyProperties(sdDto, salesApSnacksDisplay);
        salesapsnackdsDisplayMapper.updateById(salesApSnacksDisplay);
    }

    private LambdaQueryWrapper<SalesApSnacksDisplay> buildWq(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApSnacksDisplay> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(salesApWq.getSalesMonth())){
            qw.eq(SalesApSnacksDisplay::getSalesMonth, salesApWq.getSalesMonth());
        }
        if (StringUtils.isNotBlank(salesApWq.getDeptName())){
            qw.and(
                    wrapper -> wrapper.eq(SalesApSnacksDisplay::getRegionName, salesApWq.getDeptName())
                            .or()
                            .eq(SalesApSnacksDisplay::getDistrictName, salesApWq.getDeptName())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getNickName())){
            qw.and(
                    wrapper -> wrapper.eq(SalesApSnacksDisplay::getRegionManager, salesApWq.getNickName())
                            .or()
                            .eq(SalesApSnacksDisplay::getDistrictManager, salesApWq.getNickName())
                            .or()
                            .eq(SalesApSnacksDisplay::getCityManager, salesApWq.getNickName())
            );
        }
        return qw;
    }
}
