package com.sfa.job.util.aliyun;

import com.aliyun.oss.*;
import com.aliyun.oss.common.auth.BasicCredentials;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.common.comm.SignVersion;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.net.ssl.HttpsURLConnection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;

/**
 * @author : liqiulin
 * @date : 2025-08-13 15
 * @describe :
 */
@Slf4j
@Component
public class OssUtil {

    @Value("${aliyun.access-key}")
    private String accessKey;
    @Value("${aliyun.access-secret}")
    private String accessSecret;
    @Value("${aliyun.oss-sh.endpoint}")
    private String endpoint;
    @Value("${aliyun.oss-sh.bucket-name}")
    private String bucketName;
    @Value("${aliyun.oss-sh.region-id}")
    private String region;
    @Value("${aliyun.oss-sh.web-link}")
    private String webLink;

    /**
     * 上传字节流
     */
    public String uploadPhotoByte(String fileUrl,String objectName) {
        OSS ossClient = null;
        try {
            DefaultCredentialProvider credentialsProvider = new DefaultCredentialProvider(new BasicCredentials(accessKey, accessSecret, null));
            // 创建OSSClient实例，当OSSClient实例不再使用时，调用shutdown方法以释放资源。
            ClientBuilderConfiguration clientBuilderConfiguration = new ClientBuilderConfiguration();
            clientBuilderConfiguration.setSignatureVersion(SignVersion.V4);
            ossClient = OSSClientBuilder.create()
                    .endpoint(endpoint)
                    .credentialsProvider(credentialsProvider)
                    .clientConfiguration(clientBuilderConfiguration)
                    .region(region)
                    .build();
            // 填写Byte数组。
            byte[] content = imageToByte(fileUrl);
            // 创建PutObjectRequest对象。
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, objectName, new ByteArrayInputStream(content));
            // 创建PutObject请求。
            PutObjectResult result = ossClient.putObject(putObjectRequest);
            return webLink + objectName;
        } catch (OSSException oe) {
            log.error("aliyun oss 拒绝字节流上传，Error Message:{}；Error Code:{}；Request ID:{}；",oe.getErrorMessage(),oe.getErrorCode(),oe.getRequestId());
            throw new RuntimeException(oe.getMessage());
        } catch (ClientException ce) {
            log.error("aliyun oss 内部错误，字节流上传失败：{}" + ce.getMessage());
            throw new RuntimeException(ce.getMessage());
        } catch (Exception e) {
            log.error("Https类文件转换字节流异常：{}" + e.getMessage());
            throw new RuntimeException(e.getMessage());
        } finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    private byte[] imageToByte(String fileUrl) throws Exception {
        URL url = new URL(fileUrl);
        // 打开链接，并且跳过 SSL 证书验证
        HttpsUtils.trustAllHttpsCertificates();
        HttpsURLConnection conn = (HttpsURLConnection) url.openConnection();
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(5 * 1000);
        // 通过输入流获取图片数据
        InputStream inStream = conn.getInputStream();
        // 得到文件的二进制数据，以二进制封装得到数据，具有通用性
        byte[] data = readInputStream(inStream);
        // 关闭流
        inStream.close();
        return data;
    }

    private byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        // 每次读取的字符串长度，如果为-1，代表全部读取完毕
        int len = 0;
        // 使用一个输入流从buffer里把数据读取出来
        while ((len = inStream.read(buffer)) != -1) {
            // 用输出流往buffer里写入数据，中间参数代表从哪个位置开始读，len代表读取的长度
            outStream.write(buffer, 0, len);
        }
        // 关闭输入流
        inStream.close();
        // 把outStream里的数据写入内存
        return outStream.toByteArray();
    }

}
