package com.sfa.job.domain.qince.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import lombok.Data;

/**
 * 勤策-人员数据
 * @TableName qince_employee
 */
@TableName(value ="qince_employee")
@Data
public class QinceEmployee implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 勤策的员工唯一标识
     */
    private String qcId;

    /**
     * 来源第三方系统的员工唯一标识
     */
    private String empId;

    /**
     * 员工登录帐号
     */
    private String empCode;

    /**
     * 姓名
     */
    private String empName;

    /**
     * 员工别名
     */
    private String aliasName;

    /**
     * 人员编码
     */
    private String employeeCode;

    /**
     * 员工性别。F：女性，M：男性
     */
    private String empSex;

    /**
     * 员工手机号码
     */
    private String empMobile;

    /**
     * 员工手机地区码
     */
    private String mobileDistrictCode;

    /**
     * 固定电话，示例：025-68736873
     */
    private String empTel;

    /**
     * 生日。格式：yyyy-MM-dd
     */
    private String empBirthday;

    /**
     * QQ
     */
    private String empQq;

    /**
     * 微信
     */
    private String empWeixin;

    /**
     * 来源企微员工唯一标识。只有企微同步过来的人员该字段才有值
     */
    private String empWechatCode;

    /**
     * 身份证号码
     */
    private String empIdcard;

    /**
     * 邮箱
     */
    private String empEmail;

    /**
     * 地址
     */
    private String empAddr;

    /**
     * 来源第三方系统隶属部门
     */
    private String empOrgId;

    /**
     * 隶属部门编码
     */
    private String empOrgCode;

    /**
     * 勤策部门唯一标识
     */
    private String waiqin365OrgId;

    /**
     * 来源第三方系统,员工上级唯一标识
     */
    private String empParentId;

    /**
     * 员工上级编码
     */
    private String parentCode;

    /**
     * 勤策员工上级唯一标识
     */
    private String waiqin365ParentId;

    /**
     * 是否机构领导。0：否，1：是，默认值0
     */
    private String empIsOrgLearder;

    /**
     * 员工账号状态。0：销户，1：正常，2：停用
     */
    private String empStatus;

    /**
     * 手机卡绑定。0：不绑定，1：绑定
     */
    private String empImsiBinding;

    /**
     * 勤策经销商唯一标识
     */
    private String dealerId;

    /**
     * 经销商中文名称
     */
    private String dealerName;

    /**
     * 常驻地省信息
     */
    private String empBaseprovince;

    /**
     * 常驻地市信息
     */
    private String empBasecity;

    /**
     * 勤策职务唯一标识
     */
    private String waiqin365PositionId;

    /**
     * 职务编码
     */
    private String empPositionCode;

    /**
     * 职务名称
     */
    private String empPosition;

    /**
     * 勤策岗位唯一标识
     */
    private String waiqin365JobId;

    /**
     * 岗位编码
     */
    private String empJobCode;

    /**
     * 岗位名称
     */
    private String empJob;

    /**
     * 手机认证，0为是，1为否
     */
    private String mobileAuth;

    /**
     * 客户端类型。0:标准客户端（APP）、1:定制客户端（APP）、2:微信小程序、3:企业微信
     */
    private String terminalType;

    /**
     * 头像上传时间
     */
    private String faceTime;

    /**
     * 入职时间
     */
    private String empEnrollmentTime;

    /**
     * 离职时间
     */
    private String empResignationTime;

    /**
     * 最近登录时间
     */
    private String lastUseTime;

    /**
     * 创建时间
     */
    private String createTime;

    /**
     * 修改时间
     */
    private String modifyTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}