package com.sfa.job.domain.qince.dao;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.sfa.job.domain.qince.entity.QinceEmployee;
import com.sfa.job.domain.qince.mapper.QinceEmployeeMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2025-12-05 17
 * @describe :
 */
@DS("promotion")
@Service
public class QinceEmployeeDaoImpl implements IQinceEmployeeDao {
    @Autowired
    private QinceEmployeeMapper qinceEmployeeMapper;
    @Override
    public String getQcIdByEmpCode(String empCode) {
        LambdaQueryWrapper<QinceEmployee> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(QinceEmployee::getEmpCode, empCode);
        QinceEmployee qinceEmployee = qinceEmployeeMapper.selectOne(lambdaQueryWrapper);
        if (qinceEmployee == null){
            return null;
        }
        return qinceEmployee.getQcId();
    }

    @Override
    public void userResigned(String empQcId) {
        qinceEmployeeMapper.userResigned(empQcId);
    }
}
