package com.sfa.job.domain.promotion.dao;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.job.domain.promotion.entity.ActivityPlanApproval;
import com.sfa.job.domain.promotion.mapper.ActivityPlanApprovalMapper;
import com.sfa.job.domain.promotion.mapper.ActivityPlanInfoMapper;
import com.sfa.job.pojo.promotion.response.ActivityPlanApprovalDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2025-06-04 19
 * @describe :
 */
@DS("promotion")
@Service
public class ActivityPlanDaoImpl implements IActivityPlanDao{
    @Autowired
    private ActivityPlanApprovalMapper activityPlanApprovalMapper;
    @Autowired
    private ActivityPlanInfoMapper activityPlanInfoMapper;
    @Override
    public ActivityPlanApprovalDto findPlanApproval(String instanceId) {
        ActivityPlanApproval planApproval = activityPlanApprovalMapper.findPlanApproval(instanceId);
        return BeanUtils.transitionDto(planApproval, ActivityPlanApprovalDto.class);
    }

    @Override
    public void updateApprovalStatusById(Long id, String status) {
        activityPlanApprovalMapper.updateApprovalStatusById(id,status);
    }

    @Override
    public void updateActivityPlanStatusByInstanceId(String instanceId, Integer planStatusCode) {
        activityPlanInfoMapper.updateStatusByInstanceId(instanceId,planStatusCode);
    }
}
