package com.sfa.job.domain.order.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.sfa.job.domain.order.dao.IProductDao;
import com.sfa.job.domain.order.entity.PrdInfo;
import com.sfa.job.domain.order.mapper.PrdInfoMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-11-22 16
 * @describe :
 */

@DS("bi")
@Service
public class ProductDaoImpl implements IProductDao {
    @Autowired
    PrdInfoMapper prdInfoMapper;

    @Override
    public Map<String, String> selectProdSeries() {
        List<PrdInfo> prdInfos = prdInfoMapper.selectList(
                new LambdaQueryWrapper<PrdInfo>()
                        .select(PrdInfo::getSeries, PrdInfo::getPrdCode, PrdInfo::getPrdName)
                        .groupBy(PrdInfo::getSeries, PrdInfo::getPrdCode, PrdInfo::getPrdName));
        // 转换成map
        Map<String, String> prodSeriesMap = new HashMap<>();
        if (ObjectUtil.isNotEmpty(prdInfos)) {
            prdInfos.stream().forEach(prdInfoDto -> {
                prodSeriesMap.put(prdInfoDto.getPrdCode(), prdInfoDto.getPrdName());
            });
        }

        return prodSeriesMap;
    }

}
