package com.sfa.job.domain.order.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.sfa.job.domain.order.dao.FinianceBaseProductDao;
import com.sfa.job.domain.order.entity.FinanceBaseProduct;
import com.sfa.job.domain.order.mapper.FinanceBaseProductMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@DS("bi")
@Repository
public class FinianceBaseProductDaoImpl implements FinianceBaseProductDao {

    @Autowired
    FinanceBaseProductMapper mapper;

    @Override
    public Map<String, FinanceBaseProduct> selectBaseProduct() {
        // 查询所有商品
        List<FinanceBaseProduct> list = mapper.selectList(new LambdaQueryWrapper<>());
        // 以料号为key，商品对象为value，放入map中
        Map<String, FinanceBaseProduct> map = list.stream()
                .collect(HashMap::new, (k, v) -> k.put(v.getPrdCode(), v), HashMap::putAll);
        return map;
    }

    @Override
    public Map<String, FinanceBaseProduct> selectBaseProductCost(List<String> goodNos) {
        List<FinanceBaseProduct> prdInfos = mapper.selectList(
                new LambdaQueryWrapper<FinanceBaseProduct>()
                        .in(ObjectUtil.isNotEmpty(goodNos), FinanceBaseProduct::getPrdCode, goodNos));
        Map<String, FinanceBaseProduct> map = prdInfos.stream()
                .collect(HashMap::new, (k, v) -> k.put(v.getPrdCode(), v), HashMap::putAll);
        return map;
    }

}
