package com.sfa.job.domain.erp.dao;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.common.core.utils.DateUtils;
import com.sfa.job.domain.erp.entity.ErpAxmr005ShippingDetails;
import com.sfa.job.domain.erp.mapper.ErpAxmr005ShippingDetailsMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-04-08 13
 * @describe :
 */
@DS("bi")
@Service
public class ErpAxmr005ShippingDetailsDaoImpl implements ErpAxmr005ShippingDetailsDao{

    @Autowired
    private ErpAxmr005ShippingDetailsMapper erpAxmr005ShippingDetailsMapper;


    @Override
    public List<Object> getZhanquDataset(Date date) {
        List<ErpAxmr005ShippingDetails> zhanquDataset = erpAxmr005ShippingDetailsMapper.getZhanquDataset(date);
        List<Object> os = new ArrayList<>();
        long millis = System.currentTimeMillis();
        // date日期距离 1899 年 12 月 30 日的天数
        float days = (int) ((date.getTime() - DateUtils.parseDate("1899-12-30").getTime()) / (1000 * 60 * 60 * 24));
        for (ErpAxmr005ShippingDetails erpDo : zhanquDataset) {
            List<Object> data = new ArrayList<>();
            data.add(millis+"_"+erpDo.getId());
            data.add(erpDo.getShippingOrderNumber());
            data.add(days);
            data.add(erpDo.getSalesDepartmentAbbr());
            data.add(erpDo.getReceivingCustomerAbbr());
            data.add(erpDo.getProductName());
            data.add(erpDo.getQuantity());
            data.add(erpDo.getThirdPartySystemCode());
            data.add(erpDo.getDataEntryDate());
            data.add(erpDo.getShippingDate());
            data.add(erpDo.getTransportationMethodDescription());
            data.add(erpDo.getBatchNumber());
            os.add(data);
        }
        return os;
    }
}
