package com.sfa.job.domain.feishu.dao;

import com.alibaba.fastjson2.JSONArray;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.job.domain.feishu.entity.QinceMarketEmployee;
import com.sfa.job.domain.feishu.mapper.QinceMarketEmployeeMapper;
import com.sfa.job.pojo.feishu.response.QinceMarketEmployeeDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-05-20 16
 * @describe :
 */
@DS("promotion")
@Service
public class QinceMarketEmployeeDaoImpl implements IQinceMarketEmployeeDao{

    @Autowired
    QinceMarketEmployeeMapper qinceMarketEmployeeMapper;

    @Override
    public void insert(JSONArray jsonArray) {
        // jsonArray = 大区总监工号	大区总监姓名	省区经理工号	省区经理姓名	城市经理工号	城市经理姓名
        String dqEmpNo = jsonArray.getString(0);
        String dqEmpName = jsonArray.getString(1);
        String zqEmpNo = jsonArray.getString(2);
        String zqEmpName = jsonArray.getString(3);
        String csEmpNo = jsonArray.getString(4);
        String csEmpName = jsonArray.getString(5);

        List<QinceMarketEmployee> dos = new ArrayList<>();
        if (!Objects.isNull(dqEmpNo)) {
            QinceMarketEmployee dqDo = new QinceMarketEmployee().setEmpNo(dqEmpNo).setEmpName(dqEmpName)
                    .setDqEmpNo(dqEmpNo).setDqEmpName(dqEmpName);
            dos.add(dqDo);
        }
        if (!Objects.isNull(zqEmpNo)){
            QinceMarketEmployee zqDo = new QinceMarketEmployee().setEmpNo(zqEmpNo).setEmpName(zqEmpName)
                    .setZqEmpNo(zqEmpNo).setZqEmpName(zqEmpName).setDqEmpNo(dqEmpNo).setDqEmpName(dqEmpName);
            dos.add(zqDo);
        }
        if (!Objects.isNull(csEmpNo)) {
            QinceMarketEmployee csDo = new QinceMarketEmployee().setEmpNo(csEmpNo).setEmpName(csEmpName)
                    .setCsEmpNo(csEmpNo).setCsEmpName(csEmpName).setZqEmpNo(zqEmpNo).setZqEmpName(zqEmpName).setDqEmpNo(dqEmpNo).setDqEmpName(dqEmpName);
            dos.add(csDo);
        }

        if (CollectionUtils.isEmpty(dos)){
            return;
        }
        qinceMarketEmployeeMapper.batchInsert(dos);
    }

    @Override
    public List<QinceMarketEmployeeDto> selectByMd(String dateStr) {
        List<QinceMarketEmployee> dos = qinceMarketEmployeeMapper.selectByMd(dateStr);
        return BeanUtils.transitionDtos(dos, QinceMarketEmployeeDto.class);
    }
}
