package com.sfa.job.domain.order.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.job.domain.order.dao.WdtRefundAmountDetailDao;
import com.sfa.job.domain.order.entity.WdtRefundAmountDetail;
import com.sfa.job.domain.order.mapper.WdtRefundAmountDetailMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@DS("bi")
@Repository
public class WdtRefundAmountDetailDaoImpl implements WdtRefundAmountDetailDao {

    private static final int BATCH_SIZE = 1000;
    @Autowired
    private WdtRefundAmountDetailMapper amountDetailMapper;

    @Override
    public void saveOrUpdateBatch(List<WdtRefundAmountDetail> mergeList) {
        for (int i = 0; i < mergeList.size(); i += BATCH_SIZE) {
            int toIndex = Math.min(i + BATCH_SIZE, mergeList.size());
            List<WdtRefundAmountDetail> batchLists = mergeList.subList(i, toIndex);
            amountDetailMapper.saveOrUpdateBatch(batchLists);
        }
    }
}
