package com.sfa.job.domain.feishu.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * 勤策-区域销售人员架构表，来源：https://wangxiaolu.feishu.cn/sheets/QIYlsvCL9hwmBJtJ7v5ctYVsnDF?sheet=3eadb4
 * @TableName qince_market_employee
 */
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@TableName(value ="qince_market_employee")
@Data
public class QinceMarketEmployee implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;


    /**
     * 经销商代码
     */
    private String dealerCode;
    private String dealerName;

    /**
     * 大区部门编码
     */
    private String dqDeptCode;
    private String dqDeptName;

    /**
     * 战区部门编码
     */
    private String zqDeptCode;
    private String zqDeptName;

    /**
     * 大区总工号
     */
    private String dqEmpNo;
    private String dqEmpName;

    /**
     * 战区经理工号
     */
    private String zqEmpNo;
    private String zqEmpName;

    /**
     * 城市经理工号
     */
    private String csEmpNo;
    private String csEmpName;

    /**
     * 客户经理工号
     */
    private String fEmpNo;
    private String fEmpName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;
    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    public QinceMarketEmployee(String dealerCode, String dealerName, String dqDeptCode, String dqDeptName, String zqDeptCode, String zqDeptName, String dqEmpNo, String dqEmpName, String zqEmpNo, String zqEmpName, String csEmpNo, String csEmpName, String fEmpNo, String fEmpName) {
        this.dealerCode = dealerCode;
        this.dealerName = dealerName;
        this.dqDeptCode = dqDeptCode;
        this.dqDeptName = dqDeptName;
        this.zqDeptCode = zqDeptCode;
        this.zqDeptName = zqDeptName;
        this.dqEmpNo = dqEmpNo;
        this.dqEmpName = dqEmpName;
        this.zqEmpNo = zqEmpNo;
        this.zqEmpName = zqEmpName;
        this.csEmpNo = csEmpNo;
        this.csEmpName = csEmpName;
        this.fEmpNo = fEmpNo;
        this.fEmpName = fEmpName;
    }
}