package com.sfa.job.service.feishu;

import com.sfa.common.core.enums.promotion.PlanStatus;
import com.sfa.job.domain.promotion.dao.IActivityPlanDao;
import com.sfa.job.pojo.feishu.event.EventCallBackDto;
import com.sfa.job.pojo.promotion.response.ActivityPlanApprovalDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2025-06-04 17
 * @describe :
 */
@Slf4j
@Service
public class EventCallbackServiceImpl implements IEventCallbackService{
    @Autowired
    private IActivityPlanDao activityPlanDao;

    @Override
    public void planCP(EventCallBackDto.Event event) {
        String status = event.getStatus();
        String instanceId = event.getFsInstanceId();
        ActivityPlanApprovalDto planApproval = activityPlanDao.findPlanApproval(instanceId);
        if (planApproval == null){
            log.error("审批实例不存在：{}",event);
        }

        activityPlanDao.updateApprovalStatusById(planApproval.getId(),status);

        // 校验状态：已通过=已通过；非已通过=审批未通过
        PlanStatus planStatus = PlanStatus.APPROVED.name().equals(status) ? PlanStatus.NOT_EXECUTION : PlanStatus.REJECTED;
        Integer planStatusCode = planStatus.getCode();

        activityPlanDao.updateActivityPlanStatusByInstanceId(instanceId,planStatusCode);
    }
}
