package com.sfa.job.service.qince.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.sfa.common.core.utils.StringUtils;
import com.sfa.common.core.utils.sdk.FeiShuUtils;
import com.sfa.job.domain.qince.dao.IQinceEmployeeDao;
import com.sfa.job.domain.system.dao.ISysUserDao;
import com.sfa.job.pojo.qince.response.QinceEmployeeDto;
import com.sfa.job.service.qince.IQinceEmpAndDeptService;
import com.sfa.job.util.QinCeUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.groovy.util.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2025-12-29 17
 * @describe :
 */
@Slf4j
@Service
public class QinceEmpAndDeptServiceImpl implements IQinceEmpAndDeptService {
    @Autowired
    private QinCeUtils qinCeUtils;
    @Autowired
    private ISysUserDao sysUserDao;
    @Autowired
    private IQinceEmployeeDao qinceEmployeeDao;
    @Override
    public void syncQinceDealerInfo() {
        // 查询飞书的上下级关系（仅区域销售部）
        Map<String, String> empCodeAndLeader = sysUserDao.selectListEmpAndLeader();
        log.info("飞书区域销售部共【{}】人", empCodeAndLeader.size());
        List<QinceEmployeeDto> qinceEmployeeDtos = qinceEmployeeDao.selectListByEmpcodes(empCodeAndLeader.keySet());
        Set<String> leaderCodes = new HashSet<>(empCodeAndLeader.values());
        List<QinceEmployeeDto> leaderDtos = qinceEmployeeDao.selectListByEmpcodes(leaderCodes);
        Map<String, String> leaderQcIdMap = leaderDtos.stream().collect(Collectors.toMap(m -> m.getEmpCode(), m -> m.getQcId()));

        log.info("飞书关联勤策区域销售部共【{}】人", qinceEmployeeDtos.size());

        for (QinceEmployeeDto empDto : qinceEmployeeDtos) {
            String logtext;
            try {
                String leaderCode = empCodeAndLeader.get(empDto.getEmpCode());
                String leaderQcId = leaderQcIdMap.get(leaderCode);
                // 如果上级为空或上级未发生变化，则不处理
                if (StringUtils.isBlank(leaderCode) || StringUtils.isBlank(leaderQcId) || leaderCode.equals(empDto.getParentCode()) ) {
                    continue;
                }
                Map<String, Object> params = qinCeUtils.putUserLeaderParams(empDto.getQcId(), leaderQcId);
                String url = qinCeUtils.builderUrl(QinCeUtils.MODIFY_USER, params);
                qinCeUtils.postQC(url, params);
                logtext = "更新勤策【" + empDto.getEmpCode() + ":" + empDto.getEmpName() + "】的上级Leader信息【" + leaderCode + "】成功";
                log.info(logtext);
            } catch (Exception e) {
                logtext = "更新勤策【" + empDto.getEmpCode() + ":" + empDto.getEmpName() + "】的上级Leader信息失败：" + e.getMessage();
                log.error(logtext);
            }
            FeiShuUtils.pustRoot("https://open.feishu.cn/open-apis/bot/v2/hook/9793c485-d2a0-49bc-961e-578deb3b1912", logtext);
        }
    }
}
