package com.sfa.job.pojo.response;

import cn.hutool.core.date.DateUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.sfa.common.core.utils.DateUtils;
import lombok.Data;
import org.apache.commons.lang3.ObjectUtils;

import java.util.Date;

/**
 * 财务同步旺店通接口-返回数据Dto
 */
@Data
public class SyncOrderDetailDto {
    private String method;
    private String remark;
    /**
     * 订单数量
     */
    private Integer orderCount;
    private Integer orderDetailCount;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;
    private Date latestTime;
    /**
     * 同步类型 ，接口为1手动同步，0 xxljob自动同步
     */
    private Integer syncType;
    private String batchNo;
    private Integer pageNo;
    private Integer totalCount;
    /**
     * 错误信息
     */
    private String message;
    private Integer code = 200;


    public SyncOrderDetailDto setDetailInfo(String method, String remark, int syncType, int size, int mergerListSize, Integer totalCount, String batchNo, Date endTime, Date startTime) {
        // 接口测试使用
        this.setOrderCount(size);
        this.setOrderDetailCount(mergerListSize);
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this.setLatestTime(endTime);
        this.setTotalCount(totalCount);
        this.setBatchNo(batchNo);
        this.setMethod(method);
        this.setSyncType(syncType);
        this.setRemark(remark);
        return this;
    }

    public boolean validateStartTime() {
        Date currentLatest = DateUtils.addHours(new Date(), -2);
        if (currentLatest.compareTo(this.getEndTime()) < 0) {
            this.setTotalCount(0);
            String message = String.format("结束时间%s不能大于当前时间%s", DateUtil.formatDateTime(this.getEndTime()), DateUtil.formatDateTime(currentLatest));
            this.setMessage(message);
            return false;
        }
        return true;
    }


    /**
     * 初始化时间范围
     *
     * @param interval
     * @param collectOrderLog
     */
    public void setupTimeRange(Integer interval, CollectOrderLogDto collectOrderLog) {
        Date latestTime = null;
        // startTime 为空，默认是定时任务调用
        if (ObjectUtils.isEmpty(this.getStartTime())) {
            // 查询最新的采集时间
            if (ObjectUtils.isNotEmpty(collectOrderLog)) {
                latestTime = collectOrderLog.getLatestTime();
                // 调用查询旺店通接口api 获取最新日期前的一个小时
                this.setStartTime(DateUtils.addMinutes(latestTime, -5));
                this.setEndTime(DateUtils.addMinutes(this.getStartTime(), interval));
            } else {
                // 默认上个月的第一天 00:00:00
                this.setStartTime(DateUtil.beginOfDay(DateUtil.beginOfMonth(DateUtil.lastMonth())));
                this.setEndTime(DateUtils.addMinutes(this.getStartTime(), interval));
            }
        }
        this.latestTime = this.getEndTime();
        this.setLatestTime(latestTime);

    }
}
