package com.sfa.job.xxljob.qince;

import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.sfa.job.service.qince.IQinceUserStatisticService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 勤策考勤数据XXL-JOB定时任务类
 */
@Slf4j
@Component
public class QinCeAttendanceXxlJob {

    @Autowired
    private IQinceUserStatisticService qinceUserStatisticService;

    /**
     * 勤策考勤数据同步任务（XXL-JOB核心方法）
     * 调度配置：每天123:00执行（Cron表达式：0 0 23 * * ?）
     */
    @XxlJob("qinCeAttendanceSyncTodayJob")
    public void qinCeAttendanceSyncTodayJob() {
        XxlJobHelper.log("===== 开始执行勤策考勤数据同步任务（同步当天数据） =====");
        try {
            // 调用已实现的同步当天考勤数据方法
            int syncCount = qinceUserStatisticService.queryAndSaveTodayAttendance();

            // 任务结果日志
            XxlJobHelper.log("===== 勤策考勤数据同步任务执行完成，总计同步/更新{}条记录 =====", syncCount);
            // 标记任务执行成功（XXL-JOB状态回调）
            XxlJobHelper.handleSuccess("勤策考勤数据同步成功，总计同步/更新" + syncCount + "条记录");
        } catch (Exception e) {
            log.error("===== 勤策考勤数据同步任务执行失败 =====", e);
            XxlJobHelper.log("===== 勤策考勤数据同步任务执行失败，异常信息：{} =====", e.getMessage());
            XxlJobHelper.handleFail("勤策考勤数据同步失败，异常信息：" + e.getMessage());
        }
    }


    /**
     * 勤策考勤数据同步任务（XXL-JOB核心方法）
     * 调度配置：每天123:00执行（Cron表达式：0 0 23 * * ?）
     */
    @XxlJob("qinCeAttendanceSyncYesterdayJob")
    public void qinCeAttendanceSyncYesterdayJob() {
        // 1. 任务日志记录（XXL-JOB控制台可见）
        XxlJobHelper.log("===== 开始执行勤策考勤数据同步任务（同步当天数据） =====");
        try {
            // 2. 调用已实现的同步前一天考勤数据方法
            int syncCount = qinceUserStatisticService.queryAndSaveTodayAttendance();

            // 3. 任务结果日志
            XxlJobHelper.log("===== 勤策考勤数据同步任务执行完成，总计同步/更新{}条记录 =====", syncCount);
            // 4. 标记任务执行成功（XXL-JOB状态回调）
            XxlJobHelper.handleSuccess("勤策考勤数据同步成功，总计同步/更新" + syncCount + "条记录");
        } catch (Exception e) {
            // 5. 异常处理与日志记录
            log.error("===== 勤策考勤数据同步任务执行失败 =====", e);
            XxlJobHelper.log("===== 勤策考勤数据同步任务执行失败，异常信息：{} =====", e.getMessage());
            // 6. 标记任务执行失败（XXL-JOB状态回调）
            XxlJobHelper.handleFail("勤策考勤数据同步失败，异常信息：" + e.getMessage());
        }
    }

}