package com.sfa.job.util;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;

/**
 * @author : liqiulin
 * @date : 2025-06-19 17
 * @describe : T100接口对接
 */
@Slf4j
@Component
public class T100Util {

    @Value("${t100.url}")
    private String url;

    @Value("${t100.ent_id}")
    private String entId;

    public String createOrUpdateDept(JSONObject deptJson,JSONObject deptT100){
        deptJson.put("host",getHost());

        JSONObject datakey = new JSONObject();
        datakey.put("CompanyId","BJHQ");
        datakey.put("EntId",entId);
        deptJson.put("datakey",datakey);

        JSONObject payload = new JSONObject();
        deptT100.put("enterprise_no",entId);
        payload.putObject("std_data").putObject("parameter").putArray("master_data").add(deptT100);
        deptJson.put("payload",payload);

        HashMap<String,String> header = new HashMap<>();
        header.put("Content-Type","application/json;charset=utf-8");
        header.put("digi-protocol","raw");
        header.put("digi-srvver","1.0");
        header.put("digi-srvcode","000");
        header.put("digi-type","syndd c");
        header.put("digi-key","f63b06af224e90ea3f9f08e0226fc91e");
        log.info("T100-AU-DEPT参数：{}",deptJson);
        String body = HttpUtil.createPost(url).addHeaders(header).body(deptJson.toString()).execute().body();
        String msg = body.replaceAll("\n", "");
        log.info("T100-AU-DEPT结果：{}",msg);
        return msg;
    }

    public String createOrUpdateUser(JSONObject userJson) {
        userJson.put("host",getHost());
        JSONObject datakey = new JSONObject();
        datakey.put("CompanyId","BJHQ");
        datakey.put("EntId",entId);
        userJson.put("datakey",datakey);

        HashMap<String,String> header = new HashMap<>();
        header.put("Content-Type","application/json;charset=utf-8");
        header.put("digi-protocol","raw");
        header.put("digi-srvver","1.0");
        header.put("digi-srvcode","000");
        header.put("digi-type","sync");
        header.put("digi-key","f63b06af224e90ea3f9f08e0226fc91e");
        log.info("T100-AU-USER参数：{}",userJson);
        String body = HttpUtil.createPost(url).addHeaders(header).body(userJson.toString()).execute().body();
        String msg = body.replaceAll("\n", "");
        log.info("T100-AU-USER结果：{}",msg);
        return msg;

    }

    private JSONObject getHost(){
        JSONObject host = new JSONObject();
        host.put("acct","tiptop");
        host.put("ip","192.168.100.20");
        host.put("lang","zh_CN");
        host.put("prod","CRM");
        host.put("timestamp",DateUtil.format(new Date(), DatePattern.NORM_DATETIME_MS_PATTERN));
        return host;
    }
}
