package com.sfa.job.domain.feishu.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import java.io.Serializable;
import java.util.Date;

@Data
@TableName("feishu_leave_info")
public class FeishuLeaveInfo implements Serializable {
    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    // 逻辑删除常量
    // 未删除
    @TableField(exist = false)
    public static final Integer IS_DELETE_NO = 1;
    // 已删除
    @TableField(exist = false)
    public static final Integer IS_DELETE_YES = 0;

    @TableId(type = IdType.AUTO)
    private Long id;

    private String employmentId;
    private String employmentName;
    private String employmentNo;
    private String endTime;
    private String grantSource;
    private String leaveDuration;
    private Integer leaveDurationUnit;
    private String leaveProcessId;
    private String leaveRequestId;
    private Integer leaveRequestStatus;
    private String leaveTypeId;
    private String leaveTypeName;
    private String notes;
    private String returnTime;
    private String startTime;
    private String submittedAt;
    private String submittedBy;
    private String timeZone;
    private String leaveCorrectProcessId;

    private String processApplyTime;
    private String processId;
    private String processStatus;

    private Date syncCreateTime;
    private Date syncUpdateTime;

    @TableLogic(value = "1", delval = "0")
    private Integer isDelete;
}